## 产品简介
 - 消息推送SDK为应用提供了安全稳定的推送服务模块，建立了从云端到终端的消息推送通道，开发者只需在原有App中进行简单的配置和编码工作，即可快速获得实时稳定的消息推送能力。
帮助开发者专注业务开发，助力开发者快速实现消息实时推送功能。

## 功能介绍
 - 消息推送SDK为应用提供了安全稳定的推送服务模块，建立了从云端到终端的消息推送通道，开发者只需在原有App中进行简单的配置和编码工作，即可快速获得实时稳定的消息推送能力。
   帮助开发者专注业务开发，助力开发者快速实现消息实时推送功能。

## 核心优势

 - 极速安全稳定 消息毫秒级精准触达终端用户，支持每秒百万条消息下发，单机并发量可达数百万。同时消息推送双向加密，系统稳定可靠，拥有百亿级消息下发保障。
 - 智能场景分析 通过用户状态、设备状态、设备使用场景等多维度分析，预测用户合适的触达时机，圈选目标用户群主动定向推送，提升点击率，实现活跃用户高效增长。
 - 智能推送策略 支持厂商推送、离线库管理、超长消息截短、余量预警等智能组合策略，合理分配厂商资源，提升消息到达率。
 - 特色数据分析 提供下发、到达、点击等基础数据分析，还提供关闭通知、卸载用户数、消息下发日志流等特色数据分析，实现消息链路全方位智能分析。

## 安装SDK

在项目的根目录下执行如下命令，@getui/push确保v1.0.9版本及以上。

ohpm install @getui/push --registry=https://ohpm.openharmony.cn/ohpm


## 接入集成初始化 SDK
 - 我们建议开发者在 EntryAbility.onCreate()` 方法中初始化个推 SDK。多次调用 SDK 初始化并无影响。
   import Want from '@ohos.app.ability.Want';
   //引入个推SDK对外接口类PushManager
   import PushManager from '@getui/push';


  ```tsx
  import Want from '@ohos.app.ability.Want';
  //引入个推SDK对外接口类PushManager
  import PushManager from '@getui/push';
  
  export default class EntryAbility extends UIAbility {
    onCreate(want: Want, launchParam: AbilityConstant.LaunchParam): void {
      hilog.info(0x0000, 'EntryAbility', '%{public}s', 'Ability onCreate');
       //初始化GTSDK
       PushManager.initialize({
        context: this.context as common.UIAbilityContext,
        onSuccess: (cid:string) => {
          hilog.debug(0x0download/getui/harmonyos/000, "EntryAbility", '%{public}s', "个推SDK初始化成功，cid = " + cid);
        },
        onFailed: (error:string) => {
          hilog.debug(0x0000, "EntryAbility", '%{public}s', "个推SDK初始化失败，error = " + error);
        }
      })
     
    }
  }
  ```
 - 详细指南请查看：https://docs.getui.com/getui/mobile/harmonyos/vendor/vendor_open/

