//
//  SceneDelegate.m
//  SceneDemo
//
//  Created by ak on 2023/10/17.
//

#import "SceneDelegate.h"
#import "TabBarController.h"
#import "HomeViewController.h"
#import <GTSDK/GetuiSdk.h>

@interface SceneDelegate () <GeTuiSdkDelegate>
@property (nonatomic, strong) TabBarController *tabbarController;
@property (nonatomic, weak) HomeViewController *homePage;

@end

@implementation SceneDelegate

- (void)sceneDidBecomeActive:(UIScene *)scene {
    NSLog(@"[ TestDemo ] sceneDidBecomeActive %@", scene);
}

- (void)sceneWillEnterForeground:(UIScene *)scene {
    NSLog(@"[ TestDemo ] sceneWillEnterForeground %@", scene);
}


- (void)scene:(UIScene *)scene willConnectToSession:(UISceneSession *)session options:(UISceneConnectionOptions *)connectionOptions API_AVAILABLE(ios(13.0)){
    //注意: 反复多次点击通知冷启动App后杀死app，发现willConnectToSession不是每次冷启动都会调用的，可能因为复用机制而不走willConnectToSession方法。
    //此时系统会将apns参数通过GeTuiSdkDidReceiveNotification回调app, 让app也能拿到apns数据
    
    UNNotification *note = connectionOptions.notificationResponse.notification;
    NSDictionary *userInfo = note.request.content.userInfo;
    UNNotificationTrigger *trigger = note.request.trigger;
    NSLog(@"[ TestDemo ] APNs: willConnectToSession connectionOptions:%@ userInfo:%@", connectionOptions, userInfo);
    if (note && userInfo) {
        if ([trigger isKindOfClass:[UNPushNotificationTrigger class]]) {
            NSLog(@"[ TestDemo ] APNs: 远程通知");
        } else {
            NSLog(@"[ TestDemo ] APNs: 本地通知");
        }
    }
    //    guard let windowScene = (scene as? UIWindowScene) else { return }
    //           window = UIWindow(frame: windowScene.coordinateSpace.bounds)
    UIWindowScene *s = (UIWindowScene *)scene;
    self.window = [[UIWindow alloc] initWithFrame:s.coordinateSpace.bounds];
    self.window.windowScene = s;
        
    self.tabbarController = [[TabBarController alloc] init];
    self.homePage = self.tabbarController.homePage;
    self.window.rootViewController = self.tabbarController;
    [self.window makeKeyAndVisible];
    //NSLog(@"%@", [NSProcessInfo processInfo].hostName);
    NSString *msg = [NSString stringWithFormat:@"[ TestDemo ] [APN] %@ userInfo:%@", NSStringFromSelector(_cmd), userInfo];
    [self.homePage logMsg:msg];
    
    AppDelegate *del = (AppDelegate *)[UIApplication sharedApplication].delegate;
    del.tabbarController = self.tabbarController;
    del.homePage = self.homePage;
    
    //[GeTuiSdk handleSceneWillConnectWithOptions:connectionOptions];
    [del setup];
    
}

//MARK: - GeTuiSdkDelegate
 
- (void)sceneDidDisconnect:(UIScene *)scene {
    // Called as the scene is being released by the system.
    // This occurs shortly after the scene enters the background, or when its session is discarded.
    // Release any resources associated with this scene that can be re-created the next time the scene connects.
    // The scene may re-connect later, as its session was not necessarily discarded (see `application:didDiscardSceneSessions` instead).
}

- (void)sceneWillResignActive:(UIScene *)scene {
    // Called when the scene will move from an active state to an inactive state.
    // This may occur due to temporary interruptions (ex. an incoming phone call).
}



- (void)sceneDidEnterBackground:(UIScene *)scene {
    // Called as the scene transitions from the foreground to the background.
    // Use this method to save data, release shared resources, and store enough scene-specific state information
    // to restore the scene back to its current state.
}


@end
