package com.gysdk.demo;

import android.content.Context;
import android.util.Log;

import com.g.gysdk.GYManager;
import com.g.gysdk.GYResponse;
import com.g.gysdk.GyCallBack;
import com.g.gysdk.GyMessageReceiver;

/**
 * Created by cyq on 2017/3/27.
 */

public class GYReceiver extends GyMessageReceiver {

    private static final String TAG = "GYReceiver";

    @Override
    public void onInit(Context context, boolean result) {
        Log.d(TAG, "onInit:" + result);
        if (result) {
            Log.d(TAG, "onReceiverInitSuccess");
        }
    }

    @Override
    public void onError(Context context, GYResponse response) {
        Log.e(TAG, "response:" + response.toString());
    }

    @Override
    public void onGyUidReceived(Context context, String gyUid) {
        Log.d(TAG, "gyUid:" + gyUid);

        //在初始化回调中 或 进入设置中心 时，提前进行预登录 这样可以提高一键登录的速度
        GYManager.getInstance().ePreLogin(5000, new GyCallBack() {
            @Override
            public void onSuccess(GYResponse gyResponse) {
                Log.d(TAG, "receiver中 提前预登录成功:" + gyResponse);
            }

            @Override
            public void onFailed(GYResponse gyResponse) {
                Log.d(TAG, "receiver中 提前预登录失败:" + gyResponse);
            }
        });
    }

}
