package com.gysdk.demo.activity;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

import com.g.gysdk.GYManager;
import com.gysdk.demo.GYReceiver;
import com.gysdk.demo.R;
import com.gysdk.demo.util.ViewUtil;

import java.util.ArrayList;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * Time：2020-07-30 on 16:00.
 * Decription:.
 * Author:jimlee.
 */
public class GYMainActivity extends BaseActivity {
    private static final int CODE_REQUEST_PERMISSION = 0x10;

    @BindView(R.id.tv_version)
    TextView tvVersion;

    private final String TAG = getClass().getSimpleName();
    ArrayList<String> lists = new ArrayList<String>();


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ViewUtil.setStatusBarTransparent(Color.TRANSPARENT, Color.TRANSPARENT, this);
        ViewUtil.setStatusBarLightMode(false, this);
        setContentView(R.layout.activity_gy_main);
        ButterKnife.bind(this);

        toolbar.setVisibility(View.GONE);

        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.READ_EXTERNAL_STORAGE) == PackageManager.PERMISSION_DENIED) {
            lists.add(Manifest.permission.READ_EXTERNAL_STORAGE);
            lists.add(Manifest.permission.WRITE_EXTERNAL_STORAGE);
        }

        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_DENIED) {
            lists.add(Manifest.permission.READ_PHONE_STATE);
        }

        if (lists != null && !lists.isEmpty()) {
            ActivityCompat.requestPermissions(this, (String[]) lists.toArray(new String[0]), 0);
        }

        if (lists != null && !lists.isEmpty()) {
            ActivityCompat.requestPermissions(this, (String[]) lists.toArray(new String[0]), CODE_REQUEST_PERMISSION);
        } else {
            initGysdk();
        }

        tvVersion.setText(String.format("版本：%s", GYManager.getInstance().getVersion()));
        TelephonyManager telephonyManager = (TelephonyManager) getSystemService(Context.TELEPHONY_SERVICE);
        int simState = telephonyManager.getSimState();
        Log.i("TAG", "simstate = " + simState);
    }


    @OnClick({R.id.fr_elogin, R.id.fr_verify})
    public void onClicked(View view) {
        switch (view.getId()) {
            case R.id.fr_elogin:
                startActivity(new Intent(this, ChooseEloginActivity.class));
                break;
            case R.id.fr_verify:
                startActivity(new Intent(this, PhoneNumberVerifyActivity.class));
                break;

        }

    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == CODE_REQUEST_PERMISSION) {
            initGysdk();
        }
    }

    @Override
    protected void onDestroy() {
        if (gyReceiver != null) {
            unregisterReceiver(gyReceiver);
            gyReceiver = null;
        }
        super.onDestroy();
    }

    private GYReceiver gyReceiver = null;
    private void initGysdk() {
        GYManager.getInstance().setDebug(true);//开启个验debug日志
//        GYManager.getInstance().setELoginDebug(true);//开启运营商debug日志

        @Deprecated
        //老初始化接口，注意manifest静态注册和代码动态注册不要重复了
        GYReceiver oldApi = gyReceiver;
        if (oldApi != null) {
            unregisterReceiver(gyReceiver);
            gyReceiver = null;
        }
        gyReceiver = new GYReceiver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.getui.gy.action.FzXMk6LUZD6wqRjnOREsWA");
        registerReceiver(gyReceiver, intentFilter, getPackageName()+".permission.GYRECEIVER", null);
        GYManager.getInstance().init(this);

        //新初始化接口
//            GYManager.getInstance().init(this);
//        GYManager.getInstance().init(this.getApplicationContext(), new GyCallBack() {
//            @Override
//            public void onSuccess(GYResponse response) {
//                Log.e(TAG, "init onSuccess response:" + response.toString());
//            }
//
//            @Override
//            public void onFailed(GYResponse response) {
//                Log.e(TAG, "init onFailed response:" + response.toString());
//            }
//        });
//
//        GYManager.getInstance().ePreLogin(5000, new GyCallBack() {
//            @Override
//            public void onSuccess(GYResponse response) {
//                Log.e(TAG, "ePreLogin onSuccess response:" + response.toString());
//            }
//
//            @Override
//            public void onFailed(GYResponse response) {
//                Log.e(TAG, "ePreLogin onFailed response:" + response.toString());
//            }
//        });
    }
}
