package com.gysdk.demo.activity;

import android.content.Intent;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;

import com.g.gysdk.GYManager;
import com.g.gysdk.GYResponse;
import com.g.gysdk.GyCallBack;
import com.gysdk.demo.R;
import com.gysdk.demo.elogin.MyELoginActivityDialog;
import com.gysdk.demo.elogin.MyELoginActivityFloat;
import com.gysdk.demo.elogin.MyELoginActivityFullscreen;
import com.gysdk.demo.elogin.MyELoginActivityPrelogin;
import com.gysdk.demo.elogin.MyELoginActivityLandscape;
import com.gysdk.demo.util.ViewUtil;
import com.gysdk.demo.view.Choose;
import com.gysdk.demo.view.ChooseAdapter;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

import butterknife.ButterKnife;

/**
 * Time：2020-07-31 on 09:50.
 * Decription:.
 * Author:jimlee.
 */
public class ChooseEloginActivity extends BaseActivity implements ChooseAdapter.ItemClickListener {

    private final String TAG = this.getClass().getSimpleName();
    private List<Choose> chooseList = new ArrayList<>();
    RecyclerView mRecyclerView;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        ViewUtil.setStatusBarTransparent(Color.TRANSPARENT, Color.TRANSPARENT, this);
        ViewUtil.setStatusBarLightMode(false, this);

        setContentView(R.layout.activity_choose_elogin);

        toolbar.setTitleTextColor(Color.WHITE);
        toolbar.setNavigationIcon(R.drawable.ic_back_dark);
        toolbarMoveDownward();

        initChooses();
        mRecyclerView = (RecyclerView) findViewById(R.id.choose_recycler_view);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        mRecyclerView.setLayoutManager(layoutManager);
        ChooseAdapter adapter = new ChooseAdapter(chooseList);
        adapter.setOnItemClickListener(this);
        mRecyclerView.setAdapter(adapter);
        mRecyclerView.addItemDecoration(new RecyclerView.ItemDecoration() {
            @Override
            public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                super.getItemOffsets(outRect, view, parent, state);
                outRect.left = 32;
                outRect.right = 32;
                outRect.top = 40;
                outRect.bottom = 0;
            }
        });

        //在初始化回调中 或 进入设置中心 时，提前进行预登录 这样可以提高一键登录的速度
        if (!GYManager.getInstance().isPreLoginResultValid()) {
            GYManager.getInstance().ePreLogin(3000, new GyCallBack() {
                @Override
                public void onSuccess(GYResponse gyResponse) {
                    Log.d(TAG, "登录前一个界面 提前预登录成功 prelogin:" + gyResponse);
                }

                @Override
                public void onFailed(GYResponse gyResponse) {
                    Log.e(TAG, "登录前一个界面 提前预登录失败 prelogin:" + gyResponse);
                }
            });
        }

        ButterKnife.bind(this);
    }

    private void initChooses() {
        {
            Choose one = new Choose("全屏式", "页面简洁沉浸视觉体验", R.drawable.ic_fullscreen);
            chooseList.add(one);
        }
        {
            Choose one = new Choose("浮窗式", "方便操作不影响别的窗口", R.drawable.ic_floatscreen);
            chooseList.add(one);
        }
        {
            Choose one = new Choose("弹窗式", "页面中心位置吸引用户注意", R.drawable.ic_popupwindow);
            chooseList.add(one);
        }
        {
            Choose one = new Choose("横屏式", "打游戏看电视的首选模式", R.drawable.ic_landscape);
            chooseList.add(one);
        }
        {
            Choose one = new Choose("后预登录", "先起授权页面再预登录", R.drawable.ic_landscape);
            chooseList.add(one);
        }
    }

    private void eLogin(int position) {
        Class activityClass;
        switch (position) {
            case 0:
                activityClass = MyELoginActivityFullscreen.class;
                break;
            case 1:
                activityClass = MyELoginActivityFloat.class;
                break;
            case 2:
                activityClass = MyELoginActivityDialog.class;
                break;
            case 3:
                activityClass = MyELoginActivityLandscape.class;
                break;
            case 4:
                activityClass = MyELoginActivityPrelogin.class;
                break;
            default:
                Log.e(TAG, "error, what style elogin do you want?");
                return;
        }

        Log.d(TAG, "elogin startActivity");
        Intent intent = new Intent(this, activityClass);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
    }

    private long lastClickTime;
    private AtomicBoolean loginIng = new AtomicBoolean(false);

    @Override
    public void onItemClick(final int position) {
        long now = System.currentTimeMillis();
        if (now - lastClickTime < 1000) {
            Log.d(TAG, "点击太快，忽略～");
            return;
        } else if (!loginIng.compareAndSet(false, true)) {
            Log.d(TAG, "上次还未结束，忽略～");
            return;
        }
        lastClickTime = now;

        if (GYManager.getInstance().isPreLoginResultValid()
            || position == 4 //MyELoginActivityPrelogin
        ) {
            loginIng.set(false);
            eLogin(position);
        } else {
            showLoadingDialog();
            GYManager.getInstance().ePreLogin(5000, new GyCallBack() {
                @Override
                public void onSuccess(GYResponse response) {
                    Log.d(TAG, "弹登录界面需要的 预登录成功 prelogin:" + response);
                    hideLoadingDialog();
                    loginIng.set(false);
                    eLogin(position);
                }

                //预登录失败 请切换到其他验证方式
                @Override
                public void onFailed(GYResponse response) {
                    Log.e(TAG, "弹登录界面需要的 预登录失败 prelogin:" + response);
                    showToast("预登录失败 response:" + response);
                    hideLoadingDialog();
                    loginIng.set(false);
                }
            });
        }
    }
}
