//
//  AppDelegate.m
//  GyDemo
//
//  Created by admin on 2017/4/21.
//  Copyright © 2017年 getui. All rights reserved.
//

#import "AppDelegate.h"
#import "HomeViewController.h"
#import "NavigationController.h"

#define APPID @"5xpxEg5qvI9PNGH2kQAia2"

@interface AppDelegate ()

@property(nonatomic, copy) NSString *gtcid;

@end

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    self.window = [[UIWindow alloc] initWithFrame:UIScreen.mainScreen.bounds];
    self.window.rootViewController = [[NavigationController alloc] initWithRootViewController:[HomeViewController new]];
    [self.window makeKeyAndVisible];
    [GeYanSdk setDebug:YES];
    NSLog(@"%@", NSTemporaryDirectory());
    __weak AppDelegate *weakSelf = self;
    [GeYanSdk setPreLoginTimeout:10];
    [GeYanSdk setEloginTimeout:10];
    [GeYanSdk startWithAppId:APPID
                withCallback:^(BOOL isSuccess, NSError *error, NSString *gtcid) {
        if (isSuccess) {
            NSLog(@"GeYanSdk startWithAppId gtcid:%@", gtcid);
            weakSelf.gtcid = gtcid;
        } else {
            NSLog(@"GeYanSdk startWithAppId gtcid:%@", error);
        }
    }];
    
    return YES;
}

- (NSString *)getAppID {
    return APPID;
}

- (NSString *)getGtcid {
    return self.gtcid;
}

@end
