//
//  OneLoginAuthViewController.m
//  GySdkLib
//
//  Created by ak on 2021/2/23.
//  Copyright © 2021 getui. All rights reserved.
//

#import "OneLoginAuthViewController2.h"
#import "GySdkAuthContentView.h"
#import "GySdkAuthNavigationView.h"
#import "UACustomModel.h"
#import "GyCmViewController.h"

@interface OneLoginAuthViewController2 ()<UIGestureRecognizerDelegate>
@property(nonatomic, strong) GyAuthViewModel *viewModel;
@property(nonatomic, assign) GyOperatorType currentOperator;
@property(nonatomic, copy) NSString *securityPhone;
@property(nonatomic, copy) GyVerifyCallback completion;
@property(nonatomic, weak) UIViewController *parentVC;
// 返回时恢复用户设置导航隐藏状态
@property(nonatomic, assign) BOOL userNavigationBarHidden;
// Push横屏返回时恢复用户侧滑手势
@property(nonatomic, assign) BOOL userInteractivePopEnable;
@property(nonatomic, strong) GySdkAuthContentView *contentView;
@property(nonatomic, strong) UIView *popupMaskView;
@property(nonatomic, assign) GyAuthBackMode backMode;
@property(nonatomic, strong) UANavigationController * cmNavigationController;
// 点击授权按钮标记 yes之后不回调导航和侧滑返回事件
@property(nonatomic, assign) BOOL clickedLoginFlag;
@property(nonatomic, strong) UILabel *tipsLabel;
@property(nonatomic, strong) UIView *loadingContentView;
@property(nonatomic, strong) UIActivityIndicatorView *progressHUD;
@end

@implementation OneLoginAuthViewController2

//MARK: -

- (instancetype)initWithViewModel:(GyAuthViewModel *)viewModel currentOperator:(GyOperatorType)currentOperator securityPhone:(NSString *)securityPhone completion:(GyVerifyCallback)completion {
    self = [super initWithNibName:nil bundle:nil];
    if (self) {
        _viewModel = viewModel;
        _currentOperator = currentOperator;
        _securityPhone = securityPhone;
        _completion = completion;
        
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    F_GtcSafeBlockInMainQueue(_viewModel.viewLifeCycleBlock,@"viewDidLoad", YES);
    self.view.tag = TAG_PARENT;
    self.view.backgroundColor = _viewModel.backgroundColor;
    self.userNavigationBarHidden = self.navigationController.navigationBarHidden;
    self.backMode = GyAuthBackModeUnknown;
    [self loginCM];
    [self setupLandscape];
    [self setupPopup];
    [self setupView];
}

// MARK: - Property

- (UILabel *)tipsLabel {
    if (!_tipsLabel) {
        _tipsLabel = [[UILabel alloc] initWithFrame:CGRectMake((kGYScreenWidth - 200) / 2, kGYScreenHeight - [GySdkUtils safeBottomSpace] - 35 - 70, 200, 35)];
        _tipsLabel.text = _viewModel.notCheckProtocolHint;
        _tipsLabel.textAlignment = NSTextAlignmentCenter;
        _tipsLabel.font = [UIFont boldSystemFontOfSize:14];
        _tipsLabel.textColor = [UIColor whiteColor];
        _tipsLabel.layer.cornerRadius = 3;
        _tipsLabel.clipsToBounds = YES;
        _tipsLabel.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:0.35];
        _tipsLabel.hidden = YES;
    }
    return _tipsLabel;
}

- (UIActivityIndicatorView *)progressHUD {
    if (!_progressHUD) {
        _progressHUD = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleGray];
        UIWindow *window = [UIApplication sharedApplication].keyWindow;
        _progressHUD.frame = CGRectMake(CGRectGetMidX(window.frame) - 80 / 2, CGRectGetMidY(window.frame) - 80 / 2, 80, 80);
        _progressHUD.color = [UIColor whiteColor];
        _progressHUD.layer.cornerRadius = 5;
        _progressHUD.backgroundColor = [UIColor colorWithRed:1 / 255.0 green:1 / 255.0 blue:1 / 255.0 alpha:0.5];
        //刚进入这个界面会显示控件，并且停止旋转也会显示，只是没有在转动而已，没有设置或者设置为YES的时候，刚进入页面不会显示
        _progressHUD.hidesWhenStopped = YES;
        [window addSubview:_progressHUD];
    }
    return _progressHUD;
}

- (void)setBackMode:(GyAuthBackMode)backMode {
    _backMode = backMode;
    GTSLogDebug(@"setBackMode: %@", NSStringFromBackMode(backMode));
}


// MARK: - setup
- (void)setupLandscape {
    if (!_viewModel.isLandscape) {
        return;
    }
    GTSLogDebug(@"GySdk 横屏模式");
    [GySdkUtils forceRotateInterfaceOrientation:_viewModel.landscapeOrientation];
    // Push横屏时 关闭侧滑（系统黑屏bug）
    if (_viewModel.pullAuthVCStyle == OLPullAuthVCStylePush) {
        self.userInteractivePopEnable = self.navigationController.interactivePopGestureRecognizer.enabled;
        self.navigationController.interactivePopGestureRecognizer.enabled = NO;
    }
}

- (void)resetLandscape {
    if (!_viewModel.isLandscape || self.backMode == GyAuthBackModeUnknown) {
        return;
    }
    // 如有侵入用户 可注释
    //[GySdkUtils forceRotateInterfaceOrientation:UIInterfaceOrientationPortrait];
    // Push横屏返回时 恢复用户侧滑手势
    if (_viewModel.pullAuthVCStyle == OLPullAuthVCStylePush) {
        self.navigationController.interactivePopGestureRecognizer.enabled = self.userInteractivePopEnable;
    }
}

- (void)setupPopup {
    if (!_viewModel.isPopup) {
        return;
    }
//    GTSLogDebug(@"GySdk 弹窗模式");
    self.view.backgroundColor = UIColor.clearColor;
    if (_viewModel.popupMaskView && [_viewModel.popupMaskView isKindOfClass:[UIView class]]) {
        self.popupMaskView = self.viewModel.popupMaskView;
    } else {
        self.popupMaskView = [[UIView alloc] init];
        self.popupMaskView.tag = TAG_POP_UP_MASK_VIEW;
        self.popupMaskView.backgroundColor = [UIColor colorWithWhite:0 alpha:0.35];
    }
    if (self.parentVC.navigationController) {// 覆盖导航栏
        [self.parentVC.navigationController.view addSubview:self.popupMaskView];
    } else {
        [self.parentVC.view addSubview:self.popupMaskView];
    }
    if (_viewModel.canClosePopupFromTapGesture) {
        UITapGestureRecognizer *tapGes = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(popupBgBackAction)];
        tapGes.delegate = self;
        [self.view addGestureRecognizer:tapGes];
    }
}

- (void)resetPopup {
    if (!_viewModel.isPopup || self.backMode == GyAuthBackModeUnknown) {
        return;
    }
    [self.popupMaskView removeFromSuperview];
}

- (void)setupView {
    self.contentView = [[GySdkAuthContentView alloc] initWithViewModel:self.viewModel currentOperator:self.currentOperator securityPhone:self.securityPhone];
    [self.view addSubview:self.contentView];
    [self.contentView.navigationView.backButton addTarget:self action:@selector(naviBackAction) forControlEvents:UIControlEventTouchUpInside];
    [self.contentView.popupCloseButton addTarget:self action:@selector(popupCloseAction) forControlEvents:UIControlEventTouchUpInside];
    [self.contentView.switchAccountButton addTarget:self action:@selector(switchAccountAction) forControlEvents:UIControlEventTouchUpInside];
    [self.contentView.loginButton addTarget:self action:@selector(loginAction) forControlEvents:UIControlEventTouchUpInside];
    // 点击协议
    WeakObj(self);
    self.contentView.termBlock = ^(GyAuthPrivacyItem * _Nonnull item) {
        if (item.block) {
            F_GtcSafeBlockInMainQueue(item.block,item,selfWeak);
            return;
        }
        if (selfWeak.viewModel.carrierTermItemBlock) {
            F_GtcSafeBlockInMainQueue(selfWeak.viewModel.carrierTermItemBlock, item, selfWeak);
            return;
        }
        [selfWeak showTermWebController:item];
    };
    F_GtcSafeBlockInMainQueue(_viewModel.customUIHandler,self.contentView.customAreaView);
}

- (BOOL)isProtocolCheckboxChecked {
    return self.contentView.checkBoxButton.isSelected;
}

- (void)setupLoginEnable:(BOOL)enabled {
    self.contentView.loginButton.userInteractionEnabled = enabled;
}

- (void)updateAuthTitle:(NSAttributedString *)authButtonTitle {
    [self.contentView.loginButton setAttributedTitle:authButtonTitle forState:(UIControlStateNormal)];
}

// MARK: - Action
- (void)switchAccountAction {//切换账号
    NSDictionary *dic = [GyBIManager actionDicWithCode:GySdkCodeLogin errorCode:GySdkErrorLoginClickSwitchAccount];
    F_GtcSafeBlockInMainQueue(self.completion, dic);
    [GyBIManager reportAction:GyReportTypeLogin errorCode:GySdkErrorLoginClickSwitchAccount];
}

- (void)loginAction {
    [GyBIManager reportAction:GyReportTypeClickOnLogin errorCode:0];
    F_GtcSafeBlockInMainQueue(self.viewModel.clickAuthButtonBlock);
    if ([self isProtocolCheckboxChecked]) {
        //网络环境判断
        [[GTSReachabilityManager sharedManager] startMonitoring];
        GTSReachabilityStatus status = [[GTSReachabilityManager sharedManager] networkReachabilityStatus];
        if (status == GTSReachabilityStatusNotReachable) {
            NSDictionary *dic = [GyBIManager actionDicWithCode:GySdkCodeLogin errorCode:GySdkErrorNoSimNetwork];
            F_GtcSafeBlockInMainQueue(self.completion, dic);
            [GyBIManager reportAction:GyReportTypeLogin errorCode:GySdkErrorNoSimNetwork];
            return;
        }
        self.clickedLoginFlag = YES;
        [self showHUD];
        if (self.currentOperator == GyOperatorTypeCM) {
            UAAuthViewController *vc = self.cmNavigationController.childViewControllers.firstObject;
            gts_dispatch_async_on_main_queue(^{
                // 模拟移动登录，等待回调
                [vc loginForData:@(1)];
            });
        } else {
            NSDictionary *result = [[GyELoginManager manager] refreshAndUploadToken:nil];
            F_GtcSafeBlockInMainQueue(self.completion, result);
        }
    } else {
        [GyBIManager reportAction:GyReportTypeLogin errorCode:30006 ext:@"未同意隐私协议"];//比较特殊，这里code竟然不是errorcode  todo
        if (!_viewModel.showNotCheckProtocolHint) {
            return;
        }
        WeakObj(self);
        [self showTips:^{
            [selfWeak setupLoginEnable:YES];
        }];
    }
}

- (void)showTermWebController:(GyAuthPrivacyItem *)item {
    GTSLogDebug(@"GySdk didSelcted term url: %@", [item url]);
    OneLoginWebViewController *webViewController = [[OneLoginWebViewController alloc] init];
    webViewController.webTitle = item.termTitle;
    webViewController.webAttributedTitle = item.termAttributeTitle;
    webViewController.authViewModel = self.viewModel;
    webViewController.url = [item url];
    webViewController.modalPresentationStyle = self.viewModel.modalPresentationStyle;
    if (self.viewModel.modalPresentationAnimation) {
        [self.view.window.layer addAnimation:self.viewModel.modalPresentationAnimation forKey:nil];
    }
    [self presentViewController:webViewController animated:YES completion:nil];
}

// MARK: - 状态栏
- (UIStatusBarStyle)preferredStatusBarStyle {
    return self.viewModel.statusBarStyle;
}
// MARK: - 暗黑模式
- (UIUserInterfaceStyle)overrideUserInterfaceStyle {
    return (UIUserInterfaceStyle)self.viewModel.userInterfaceStyle.integerValue;
}
// MARK: - 屏幕旋转
// 横屏模式用户需设置navigationController和tabbarController的top vc
//- (BOOL)shouldAutorotate {
//    return YES;
//}
- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return self.viewModel.supportedInterfaceOrientations;
}

- (void)viewWillTransitionToSize:(CGSize)size withTransitionCoordinator:(id<UIViewControllerTransitionCoordinator>)coordinator {
    [super viewWillTransitionToSize:size withTransitionCoordinator:coordinator];
    F_GtcSafeBlockInMainQueue(_viewModel.authVCTransitionBlock, size, coordinator, self.contentView.customAreaView);
}


// MARK: - Lifecycle
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    F_GtcSafeBlockInMainQueue(_viewModel.viewLifeCycleBlock,@"viewWillAppear",animated);
    [self.navigationController setNavigationBarHidden:YES animated:animated];
}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];
    F_GtcSafeBlockInMainQueue(_viewModel.viewLifeCycleBlock,@"viewDidLayoutSubviews",YES);
    if (_viewModel.isPopup) {
        self.popupMaskView.frame = self.view.bounds;
        self.contentView.frame = [GySdkUtils centerXRectMake:_viewModel.popupRect
                                                           y:(self.view.bounds.size.height - kGySdk_UI_Popup_Size.height)/2
                                                 defaultSize:kGySdk_UI_Popup_Size
                                                  parentSize:self.view.bounds.size
                                                 isLandscape:_viewModel.isLandscape];
    } else {
        self.contentView.frame = self.view.bounds;
    }
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    F_GtcSafeBlockInMainQueue(_viewModel.viewLifeCycleBlock,@"viewWillDisappear",animated);
    [self.navigationController setNavigationBarHidden:self.userNavigationBarHidden animated:animated];
    [self resetLandscape];
    [self resetPopup];
}

- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
    F_GtcSafeBlockInMainQueue(_viewModel.viewLifeCycleBlock,@"viewDidDisappear",animated);
}

// MARK: - 页面返回
- (void)naviBackAction {
    self.backMode = GyAuthBackModeNavigation;
    NSDictionary *dic = [GyBIManager actionDicWithCode:GySdkCodeLogin errorCode:GySdkErrorLoginClickBack];
    F_GtcSafeBlockInMainQueue(self.completion, dic);
    [GyBIManager reportAction:GyReportTypeLogin errorCode:GySdkErrorLoginClickBack ext:@"点击返回"];
    [self closeViewController];
}

/// 侧滑返回
- (void)didMoveToParentViewController:(UIViewController *)parent {
    [super didMoveToParentViewController:parent];
    if (!parent &&
        self.backMode != GyAuthBackModeNavigation &&
        self.backMode != GyAuthBackModeAPI) {
//      &&  !self.clickedLoginFlag
        GTSLogDebug(@"swipe back");
        self.backMode = GyAuthBackModeNavigationGesture;
        
        NSDictionary *dic = [GyBIManager actionDicWithCode:GySdkCodeLogin errorCode:GySdkErrorLoginClickBack];
        F_GtcSafeBlockInMainQueue(self.completion, dic);
        [GyBIManager reportAction:GyReportTypeLogin errorCode:GySdkErrorLoginClickBack ext:@"点击返回"];
        [self closeViewController];
        if (_viewModel.pullAuthVCStyle == OLPullAuthVCStylePush) {
            [self.navigationController setNavigationBarHidden:NO];
        }
    }
//    if (!parent && GeYanSdk.currentAuthViewController != nil && GyOneLoginService.shareInstance.isOneLoginPageLoaded) {
//        GyLogDebug(@"swipe back");
//        [self performBackBlock];
//        [GyOneLoginService.shareInstance closeAuthVC:NO completion:nil];
//        if (_authViewModel.pullAuthVCStyle == OLPullAuthVCStylePush) {
//            [self.navigationController setNavigationBarHidden:NO];
//        }
//    }
}

- (void)popupCloseAction {
    self.backMode = GyAuthBackModePopup;
    [self closeViewController];
}

- (void)popupBgBackAction {
    self.backMode = GyAuthBackModePopupGesture;
    F_GtcSafeBlockInMainQueue(_viewModel.tapAuthBackgroundBlock);
    [self closeViewController];
}

- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch {
    // 弹窗模式 屏蔽点击背景关闭手势
    if (_viewModel.isPopup &&
        [touch.view isDescendantOfView:self.contentView]) {
        return NO;
    }
    return YES;
}

- (void)dismissAuth:(BOOL)animated completion:(void (^ __nullable)(void))completion {
    self.backMode = GyAuthBackModeAPI;
    [self closeViewController:animated completion:completion];
}

// MARK: - 提示视图
- (void)showTips:(GySdkBlock)completion {
    if (!_viewModel.showNotCheckProtocolHint) {
        return;
    }
    [UIView animateWithDuration:0.3 animations:^{
        [self.view addSubview:self.tipsLabel];
        self.tipsLabel.hidden = NO;
    }];
    
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, NSEC_PER_SEC*2), dispatch_get_main_queue(), ^{
        [UIView animateWithDuration:0.3 animations:^{
            self.tipsLabel.hidden = YES;
            [self.tipsLabel removeFromSuperview];
            F_GtcSafeBlock(completion);
        }];
    });
}

- (void)showHUD {
    if (_viewModel.loadingViewBlock) {
        if (_loadingContentView) {
            [_loadingContentView removeFromSuperview];
            _loadingContentView = nil;
        }
        _loadingContentView = [[UIView alloc] initWithFrame:self.view.bounds];
        [self.view addSubview:_loadingContentView];
        F_GtcSafeBlockInMainQueue(_viewModel.loadingViewBlock, _loadingContentView);
    } else {
        gts_dispatch_async_on_main_queue(^{
            [self.progressHUD startAnimating];
        });
    }
    [self setupLoginEnable:NO];
}

- (void)hideHUD {
    if (_viewModel.loadingViewBlock) {
        [_loadingContentView removeFromSuperview];
        F_GtcSafeBlockInMainQueue(_viewModel.stopLoadingViewBlock, _loadingContentView);
        _loadingContentView = nil;
    } else {
        gts_dispatch_async_on_main_queue(^{
            [self.progressHUD stopAnimating];
        });
    }
    [self setupLoginEnable:YES];
}

// MARK: - Public
+ (instancetype)oneTapLogin:(UIViewController *)viewController
                  viewModel:(GyAuthViewModel *)viewModel
            currentOperator:(GyOperatorType)currentOperator
              securityPhone:(NSString *)securityPhone
                 completion:(GyVerifyCallback)completion {
    OneLoginAuthViewController *authController = [[OneLoginAuthViewController alloc] initWithViewModel:viewModel currentOperator:currentOperator securityPhone:securityPhone completion:completion];
    authController.parentVC = viewController;
    if (viewModel.pullAuthVCStyle == OLPullAuthVCStylePush
        && viewController.navigationController
        && !viewModel.isPopup) {
        [viewController.navigationController pushViewController:authController animated:viewModel.pullAnimate];
    } else {
        // 纠正 OLPullAuthVCStylePush 导航为空
        BOOL animated = YES;
        viewModel.pullAuthVCStyle = OLPullAuthVCStyleModal;
        authController.modalPresentationStyle = viewModel.modalPresentationStyle;
        if (viewModel.isPopup) {
            viewController.definesPresentationContext = YES;
            authController.modalPresentationStyle = UIModalPresentationOverFullScreen;
            if (viewModel.popupAnimationStyle == OLAuthPopupAnimationStyleCustom) {
                animated = NO;
                [viewController.view.window.layer addAnimation:viewModel.popupTransitionAnimation forKey:nil];
            } else {
                authController.modalTransitionStyle = (NSInteger)viewModel.popupAnimationStyle;
            }
        } else {
            if (viewModel.modalPresentationAnimation) {
                animated = NO;
                [viewController.view.window.layer addAnimation:viewModel.modalPresentationAnimation forKey:nil];
            }
        }
        dispatch_async(dispatch_get_main_queue(), ^{
            [viewController presentViewController:authController animated:viewModel.pullAnimate completion:nil];
        });
    }
    return authController;
}

// MARK: - 关闭
- (void)closeViewController:(BOOL)animated completion:(void (^ __nullable)(void))completion {
//    [self updateAction:(GyReportTypeCompletion) isReport:NO];
    [self hideHUD];
    if ([GyELoginManager manager].loginViewController == nil) {
        //已经关闭，避免重复调用，导致多次dismiss
        return;
    }
    self.parentVC = nil;
    self.completion = nil;
    [[GyELoginManager manager] resetLogin];
    if (_viewModel.pullAuthVCStyle == OLPullAuthVCStyleModal) {
        BOOL animation = animated;
        if (_viewModel.isPopup) {
            if ( _viewModel.popupAnimationStyle == OLAuthPopupAnimationStyleCustom) {
                animation = NO;
                [self.view.window.layer addAnimation:_viewModel.popupTransitionAnimation forKey:nil];
            }
        } else {
            if (_viewModel.modalDismissAnimation) {
                animation = NO;
                [self.view.window.layer addAnimation:_viewModel.modalDismissAnimation forKey:nil];
            }
        }
        gts_dispatch_async_on_main_queue(^{
            [self dismissViewControllerAnimated:animated completion:completion];
        });
    } else {
        [self.navigationController popViewControllerAnimated:animated];
        F_GtcSafeBlockInMainQueue(completion);
    }
}

- (void)closeViewController {
    [self closeViewController:YES completion:nil];
}

// MARK: - 移动
static BOOL isOpenCMAuth = NO;
static double cmTimestamp = 0;

- (void)loginCM {
    if (kNoSimLogin) {
        return;
    }
    if (self.currentOperator == GyOperatorTypeUNKNOW) {
        F_GtcSafeBlockInMainQueue(self.completion, [GySdkUtils errorDicWithCode:GySdkCodeLogin errorCode:GySdkErrorOperatorUnknown]);
    }
    if (self.currentOperator != GyOperatorTypeCM) {
//        非移动，直接拿到一键登录结果 //akak 老版本没有此埋点
//        [GyBIManager reportAction:GyReportTypeLogin errorCode:GySdkCodeSuccess];
        return;
    }
    //登录移动
    UACustomModel *cmModel = [[UACustomModel alloc]init];
    cmModel.currentVC = self;
    isOpenCMAuth = NO;
    WeakObj(self);
    cmTimestamp = F_GtcCurrentTimeInterval_13;
    //注册移动回调。 首次viewdidload后会先 打开移动授权页 ， 用户点击登录后，将收到token
    [[UASDKLogin shareLogin] getAuthorizationWithModel:cmModel complete:^(NSDictionary *dic) {
        ELoginCMModel *cm = [ELoginCMModel modelWithDictionary:dic];
        if ([cm isSuccess] && cm.token.length > 0) {
            //用户点击登录，会收到移动的回调。 登录成功，回调外部
            NSDictionary *result = [[GyELoginManager manager] refreshAndUploadToken:cm.token];//上传token 并 刷新tokenModel中的accessCode
            [GyBIManager reportAction:GyReportTypeLogin errorCode:0 cost:F_GtcCurrentTimeInterval_13 - cmTimestamp];
            F_GtcSafeBlockInMainQueue(self.completion, result);
        } else if ([cm.resultCode isEqualToString:UASDKSuccessGetAuthVCCode]) {
            //打开移动授权页
            isOpenCMAuth = YES;
            [GyBIManager reportAction:GyReportTypeOpenAuthPage errorCode:0];
        } else {
            //失败，回调外部
            [UASDKLogin.shareLogin ua_dismissViewControllerAnimated:false completion:nil];
            if (isOpenCMAuth) {
                //打开过授权页，登录失败
                [[GyELoginManager manager].tokenModel updateWithErrorCode:GySdkErrorOpenPageCMFailed info:dic];
                [GyBIManager reportAction:GyReportTypeClickOnLogin errorCode:GySdkErrorLoginTokenInvalid ext:@"获取token失败"];
            } else {
                [[GyELoginManager manager].tokenModel updateWithErrorCode:GySdkErrorLoginCMError info:dic];
                [GyBIManager reportAction:GyReportTypeOpenAuthPage errorCode:GySdkErrorLoginCMError];
            }
            F_GtcSafeBlockInMainQueue(selfWeak.completion, [[GyELoginManager manager].tokenModel preGetTokenResult]);
        }
    }];
}

- (void)presentViewController:(UANavigationController *)viewControllerToPresent animated:(BOOL)flag completion:(void (^)(void))completion {
    if ([viewControllerToPresent isKindOfClass:[UANavigationController classForCoder]]) {
        [viewControllerToPresent.view layoutIfNeeded];
        viewControllerToPresent.view.alpha = 0.02;
        viewControllerToPresent.view.frame = CGRectMake(self.view.frame.size.width - 0.5,self.view.frame.size.height - 0.5, 0.5, 0.5);
        self.cmNavigationController = viewControllerToPresent;
        [self addChildViewController:viewControllerToPresent];
        [self.view addSubview:viewControllerToPresent.view];
    } else {
        [super presentViewController:viewControllerToPresent animated:YES completion:completion];
    }
}

// MARK: - 更新事件回调
//- (void)updateAction:(GyReportType)action isReport:(BOOL)isReport {
//    if ([self.delegate respondsToSelector:@selector(loginController:changeAction:isReport:)]) {
//        [self.delegate loginController:self changeAction:action isReport:isReport];
//    }
//}
//// MARK: - 错误回调
//- (void)completionWithErrorCode:(GySdkCode)errorCode param:(nullable NSDictionary *)param {
//    if ([self.delegate respondsToSelector:@selector(loginController:errorCode:param:)]) {
//        [self.delegate loginController:self errorCode:errorCode param:param];
//    }
//}

- (void)dealloc {
    GTSLogDebug(@"%@ dealloc", self);
}
@end
