//
// Created by lzy on 2019/10/29.
// Copyright (c) 2019 getui. All rights reserved.
//

#pragma clang diagnostic push
#pragma ide diagnostic ignored "ResourceNotFoundInspection"
@interface OneLoginWebViewController ()
@property(nonatomic, assign) UIStatusBarStyle appStatusBarStyle;
@property(nonnull, strong) UIView *navigationView;
@property(nonnull, strong) UIView *navView;
@property(nonnull, strong) UIButton *backBtn;
@property(nonnull, strong) UILabel *titleLabel;
@property(nonatomic, strong) WKWebView *webView;
@property(nonatomic, strong) UIActivityIndicatorView *defaultLoadingView;
@property(nonatomic, assign) BOOL appNaviBarHidden;
@end

@implementation OneLoginWebViewController


- (UIStatusBarStyle)preferredStatusBarStyle {
    return _authViewModel.statusBarStyle;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    if (_authViewModel.pullAuthVCStyle == OLPullAuthVCStylePush) {
        self.appNaviBarHidden = self.navigationController.navigationBarHidden;
        self.navigationController.navigationBarHidden = YES;
    }
//    _appStatusBarStyle = [UIApplication sharedApplication].statusBarStyle;
//    [UIApplication sharedApplication].statusBarStyle = _authViewModel.statusBarStyle;
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    if (_authViewModel.pullAuthVCStyle == OLPullAuthVCStylePush) {
        self.navigationController.navigationBarHidden = _appNaviBarHidden;
    }
    //[UIApplication sharedApplication].statusBarStyle = _appStatusBarStyle;
}

- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return _authViewModel.supportedInterfaceOrientations;
}


- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];
    [self layoutFrame];
}
- (void)layoutFrame {

    CGFloat statusHeight = [[UIApplication sharedApplication] statusBarFrame].size.height;
    CGFloat screenWidth = [UIScreen mainScreen].bounds.size.width;
    CGFloat screenHeight = [UIScreen mainScreen].bounds.size.height;

    if (!_authViewModel.webNaviHidden) {
        //navi
        _navigationView.frame = CGRectMake(0, 0, screenWidth, 44 + statusHeight);
        _navView.frame = CGRectMake(0, statusHeight, screenWidth, 44);
        CGSize backSize = [GySdkUtils sizeMake:self.authViewModel.webBackBtnRect defaultSize:CGSizeMake(40, 40)];;
        CGPoint backPoint = [GySdkUtils originMake:self.authViewModel.webBackBtnRect
                                     defaultOrigin:CGPointMake(0, (44-backSize.height)/2)
                                        parentSize:CGSizeMake(screenWidth, 44)
                                       isLandscape:self.authViewModel.isLandscape];
        self.backBtn.frame = CGRectMake(backPoint.x, backPoint.y, backSize.width, backSize.height);
        CGSize size = [_titleLabel.text sizeWithAttributes:@{NSFontAttributeName: _titleLabel.font}];
        CGSize adaptionSize = CGSizeMake(ceilf((float) size.width), ceilf((float) size.height));
        _titleLabel.frame = CGRectMake((screenWidth - adaptionSize.width)/2, 0, adaptionSize.width, 44);
    }

    //webview
    _webView.frame = CGRectMake(0, 44 + statusHeight, screenWidth, screenHeight - 44 - statusHeight);
}

- (void)viewDidLoad {
    [super viewDidLoad];
    if (_authViewModel.isLandscape) {
        [GySdkUtils forceRotateInterfaceOrientation:_authViewModel.landscapeOrientation];
    }
    self.view.backgroundColor = _authViewModel.backgroundColor ?: [UIColor whiteColor];
    if (!_authViewModel.webNaviHidden) {
        _navigationView = [UIView new];
        //设置背景颜色
        [_navigationView setBackgroundColor:_authViewModel.webNaviBgColor ?: [UIColor whiteColor]];
        [self.view addSubview:_navigationView];

        _navView = [UIView new];
        [_navigationView addSubview:_navView];
        if (!_authViewModel.webBackBtnHidden) {
            //返回按钮
            self.backBtn = [UIButton new];
            [_navView addSubview:self.backBtn];
            //设置返回图片
            if (_authViewModel.webBackBtnImg) {
                [self.backBtn setImage:_authViewModel.webBackBtnImg forState:UIControlStateNormal];
            } else {
                [self.backBtn setImage:[UIImage imageNamed:@"TYRZResource.bundle/back_13x21_.png"] forState:UIControlStateNormal];
            }
            self.backBtn.imageView.contentMode = UIViewContentModeScaleAspectFit;
        }
        //标题
        _titleLabel = [UILabel new];
        [_navView addSubview:_titleLabel];
        if (_authViewModel.webNaviTitle) {
            if ([_authViewModel.webNaviTitle isKindOfClass:[NSAttributedString class]]) {
                _titleLabel.attributedText = _authViewModel.webNaviTitle;
            } else {
                @throw [[NSException alloc] initWithName:NSInvalidArgumentException reason:@"navigation title must be NSAttributedString" userInfo:@{}];
            }
        } else if (self.webAttributedTitle) {
            _titleLabel.attributedText = self.webAttributedTitle;
        } else {
            _titleLabel.attributedText = [[NSMutableAttributedString alloc]
                    initWithString:_webTitle ?: @"服务条款"
                        attributes:@{NSForegroundColorAttributeName: [UIColor blackColor],
                                NSFontAttributeName: [UIFont boldSystemFontOfSize:17]}];
        }
    }

    WKWebView *web = WKWebView.new;
    [self.view addSubview:web];
    _webView = web;
    _webView.navigationDelegate = self;
    NSURLRequest *urlRequest = [[NSURLRequest alloc] initWithURL:_url cachePolicy:(NSURLRequestUseProtocolCachePolicy) timeoutInterval:15];
    [_webView loadRequest:urlRequest];

    [_backBtn addTarget:self action:@selector(performBack:) forControlEvents:UIControlEventTouchUpInside];

    [self setNeedsStatusBarAppearanceUpdate];
}

- (void)webView:(WKWebView *)webView didStartProvisionalNavigation:(null_unspecified WKNavigation *)navigation {
    [self showLoadingView];
}

- (void)webView:(WKWebView *)webView didFinishNavigation:(null_unspecified WKNavigation *)navigation {
    [self removeLoadingView];
}

- (void)webView:(WKWebView *)webView didFailNavigation:(null_unspecified WKNavigation *)navigation withError:(NSError *)error {
    [self removeLoadingView];
}

- (void)webView:(WKWebView *)webView didFailProvisionalNavigation:(null_unspecified WKNavigation *)navigation withError:(NSError *)error {
    [self removeLoadingView];
}

- (void)performBack:(id)sender {
    if (_webView.canGoBack) {
        [_webView goBack];
        return;
    }
    if (_authViewModel.modalDismissAnimation) {
        [self.view.window.layer addAnimation:_authViewModel.modalDismissAnimation forKey:nil];
    } else {
        self.modalTransitionStyle = UIModalTransitionStyleCoverVertical;
    }
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)showLoadingView {
    [self removeLoadingView];
    _defaultLoadingView = [UIActivityIndicatorView new];
    [self.view addSubview:_defaultLoadingView];
    _defaultLoadingView.color = [UIColor whiteColor];
    _defaultLoadingView.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:0.35];
    CGSize size = [UIScreen mainScreen].bounds.size;
    _defaultLoadingView.frame = CGRectMake((size.width-40)/2, (size.height-40)/2, 40, 40);
    _defaultLoadingView.layer.cornerRadius = 3;
    self.view.userInteractionEnabled = NO;

    CGAffineTransform transform = CGAffineTransformMakeScale(2.f, 2.f);
    _defaultLoadingView.transform = transform;

    [_defaultLoadingView startAnimating];
}

- (void)removeLoadingView {
    if (self.defaultLoadingView) {
        [self.defaultLoadingView removeFromSuperview];
        self.defaultLoadingView = nil;
    }
    self.view.userInteractionEnabled = YES;
}

- (void)dealloc {
    GTSLogDebug(@"%@ dealloc", self);
}
@end

#pragma clang diagnostic pop
