//
//  OLUtil.h
//  GySdkLib
//
//  Created by lzy on 2020/6/29.
//  Copyright © 2020 getui. All rights reserved.
//


NS_ASSUME_NONNULL_BEGIN

static CGFloat dfLogoYOffset;
static CGFloat dfPNYOffset;
static CGFloat dfSwitchAccountYOffset;
static CGFloat dfAuthBtnYOffset;
static CGFloat dfSloganYOffset;
static CGFloat dfTermsYOffset;
static CGFloat dfAlertYOffset;
static CGFloat designY = 896;
static CGFloat designX = 414;
static CGFloat dfPopW = 300;
static CGFloat dfPopH = 340;

static const int TAG_BASE_NUM = 0;
static const int TAG_PARENT = TAG_BASE_NUM + 1;
static const int TAG_BACKGROUND_IMAGE = TAG_PARENT + 1;
static const int TAG_NAVIGATION = TAG_BACKGROUND_IMAGE + 1;
static const int TAG_NAVIGATION_ITEM = TAG_NAVIGATION + 1;
static const int TAG_NAVIGATION_ITEM_BACK = TAG_NAVIGATION_ITEM + 1;
static const int TAG_NAVIGATION_ITEM_TITLE = TAG_NAVIGATION_ITEM_BACK + 1;
static const int TAG_NAVIGATION_ITEM_RIGHT = TAG_NAVIGATION_ITEM_TITLE + 1;
static const int TAG_CUSTOM = TAG_NAVIGATION_ITEM_RIGHT + 1;
static const int TAG_LOGO = TAG_CUSTOM + 1;
static const int TAG_PN = TAG_LOGO + 1;
static const int TAG_EXCHANGE = TAG_PN + 1;
static const int TAG_LOGIN_BUTTON = TAG_EXCHANGE + 1;
static const int TAG_SLOGAN = TAG_LOGIN_BUTTON + 1;
static const int TAG_TERMS_ITEM = TAG_SLOGAN + 1;
static const int TAG_TERMS_ITEM_CHECKBOX = TAG_TERMS_ITEM + 1;
static const int TAG_TERMS_ITEM_LABEL = TAG_TERMS_ITEM_CHECKBOX + 1;
static const int TAG_POP_UP_MASK_VIEW = TAG_TERMS_ITEM_LABEL + 1;

@interface OLUtil : NSObject
+ (BOOL)checkFValid:(CGFloat)value left:(CGFloat)left right:(CGFloat)right;

+ (BOOL)checkSizeValid:(CGSize)value widthLimit:(CGFloat)wl heightLimit:(CGFloat)hl;

+ (BOOL)checkArrayValid:(NSArray *_Nullable)array;

+ (void)resetFrameSize:(UIView *_Nonnull)itemView size:(CGSize)size;

+ (void)calculateCenterWithRect:(OLRect)olRect authViewModel:(GyAuthViewModel *_Nonnull)authViewModel isPortrait:(BOOL)isPortrait itemView:(UIView *_Nonnull)itemView isInternalView:(BOOL)internal childWidth:(CGFloat)width;

+ (void)calculateLabelFrameWithCenterX:(CGFloat)centerX offsetY:(CGFloat)offsetY itemView:(UILabel *_Nonnull)labelView olRect:(OLRect)olRect authViewModel:(GyAuthViewModel *_Nonnull)authViewModel isPortrait:(BOOL)isPortrait size:(CGSize)size adaptionSize:(CGSize)adaptionSize;
@end

NS_ASSUME_NONNULL_END
