//
//  OLUtil.m
//  GySdkLib
//
//  Created by lzy on 2020/6/29.
//  Copyright © 2020 getui. All rights reserved.
//
#import "OLUtil.h"

@implementation OLUtil

+ (BOOL)checkFValid:(CGFloat)value left:(CGFloat)left right:(CGFloat)right {
    return value > left && value <= right;
}

+ (BOOL)checkSizeValid:(CGSize)value widthLimit:(CGFloat)wl heightLimit:(CGFloat)hl {
    return [self checkFValid:value.width left:0 right:wl] && [self checkFValid:value.height left:0 right:hl];
}

+ (BOOL)checkArrayValid:(NSArray *)array {
    if (!array) {
        return false;
    }
    for (unsigned int i = 0; i < array.count; ++i) {
        if (array[i] == nil) {
            return false;
        }
    }
    return true;
}

+ (void)resetFrameSize:(UIView *)itemView size:(CGSize)size {
    CGRect frame;
    frame = itemView.frame;
    frame.size = size;
    itemView.frame = frame;
}

+ (void)calculateCenterWithRect:(OLRect)olRect authViewModel:(GyAuthViewModel *_Nonnull)authViewModel isPortrait:(BOOL)isPortrait itemView:(UIView *_Nonnull)itemView isInternalView:(BOOL)internal childWidth:(CGFloat)width {
    CGFloat statusHeight = [[UIApplication sharedApplication] statusBarFrame].size.height;
    CGFloat center_x = 0;
    CGFloat center_y = 0;
    if (olRect.portraitLeftXOffset || olRect.landscapeLeftXOffset) {
        center_x = isPortrait ? olRect.portraitLeftXOffset : olRect.landscapeLeftXOffset;
        if (center_x) {
            if (width) {
                center_x = width / 2 + center_x;
            } else {
                center_x = itemView.frame.size.width / 2 + center_x;
            }
        }
    } else if (olRect.portraitCenterXOffset || olRect.landscapeCenterXOffset) {
        center_x = isPortrait ? olRect.portraitCenterXOffset : olRect.landscapeCenterXOffset;
        if (center_x) {
            center_x = [UIScreen mainScreen].bounds.size.width / 2 + center_x;
        }
    }
    if (olRect.portraitTopYOffset || olRect.landscapeTopYOffset) {
        center_y = isPortrait ? olRect.portraitTopYOffset : olRect.landscapeTopYOffset;
        if (center_y) {
            center_y = center_y + itemView.frame.size.height / 2;
        }
    }
    CGPoint center = itemView.center;
    if (center_x) {
        center.x = center_x;
    }
    if (center_y) {
        CGFloat temp;
        temp = internal ? 0 : (statusHeight + (authViewModel.naviHidden ? 0 : 44));
        center.y = center_y + (authViewModel.isPopup ? 0 : temp);
    }
    itemView.center = CGPointMake(center.x, center.y);
}

+ (void)calculateLabelFrameWithCenterX:(CGFloat)centerX offsetY:(CGFloat)offsetY itemView:(UILabel *_Nonnull)labelView olRect:(OLRect)olRect authViewModel:(GyAuthViewModel *_Nonnull)authViewModel isPortrait:(BOOL)isPortrait size:(CGSize)size adaptionSize:(CGSize)adaptionSize {
    CGFloat screenWidth = [UIScreen mainScreen].bounds.size.width;
    CGFloat screenHeight = [UIScreen mainScreen].bounds.size.height;

    if ([self checkSizeValid:(olRect).size widthLimit:screenWidth heightLimit:screenHeight]) {
        [self resetFrameSize:labelView size:(olRect).size];
    } else {
        size = [labelView.text sizeWithAttributes:@{NSFontAttributeName: labelView.font}];
        adaptionSize = CGSizeMake(ceilf((float) (size).width), ceilf((float) (size).height));
        [self resetFrameSize:labelView size:adaptionSize];
    }
    if (authViewModel.isPopup) {
        labelView.center = CGPointMake(centerX, (offsetY + labelView.frame.size.height / 2));
    } else {
        labelView.center = CGPointMake(centerX, (offsetY + labelView.frame.size.height / 2) / designY * screenHeight);
    }
    [self calculateCenterWithRect:olRect authViewModel:authViewModel isPortrait:isPortrait itemView:labelView isInternalView:NO childWidth:0];
}

@end
