//
//  UIImage+OL.m
//  OneLoginSDK
//
//  Created by NikoXu on 2019/4/1.
//  Copyright © 2019 geetest. All rights reserved.
//

#import "UIImage+OL.h"
//#import "NSBundle+OL.h"

@implementation UIImage (OL)
+ (NSArray<UIImage *> *)ol_animatedImagesWithGifPath:(NSString *)path duration:(NSTimeInterval *)duration lastFrameImage:(UIImage **)lastFrameImage {
    if (nil != path) {
        NSData *data = [NSData dataWithContentsOfFile:path];
        if (data) {
            return [UIImage animatedImagesWithData:data duration:duration lastFrameImage:lastFrameImage];
        }
    }
    return nil;
}
+ (NSArray<UIImage *> *)animatedImagesWithData:(NSData *)data duration:(NSTimeInterval *)duration lastFrameImage:(UIImage **)lastFrameImage {
    if (NULL != duration) {
        *duration = 0;
    }

    if (NULL != lastFrameImage) {
        *lastFrameImage = nil;
    }

    if (!data) {
        return nil;
    }

    CGImageSourceRef source = CGImageSourceCreateWithData((__bridge CFDataRef) data, NULL);

    size_t count = CGImageSourceGetCount(source);

    NSMutableArray *images = [NSMutableArray array];

    if (count <= 1) {
        UIImage *animatedImage = [[UIImage alloc] initWithData:data];
        if (animatedImage) {
            if (NULL != lastFrameImage) {
                *lastFrameImage = animatedImage;
            }
            CFRelease(source);
            return @[animatedImage];
        }
    } else {
        NSTimeInterval tempDuration = 0.0f;

        for (size_t i = 0; i < count; i++) {
            CGImageRef image = CGImageSourceCreateImageAtIndex(source, i, NULL);
            if (!image) {
                continue;
            }

            tempDuration += [self frameDurationAtIndex:i source:source];

            [images addObject:[UIImage imageWithCGImage:image scale:[UIScreen mainScreen].scale orientation:UIImageOrientationUp]];

            if (i == count - 1) {
                if (NULL != lastFrameImage) {
                    *lastFrameImage = [UIImage imageWithCGImage:image scale:[UIScreen mainScreen].scale orientation:UIImageOrientationUp];
                }
            }

            CGImageRelease(image);
        }

        if (!tempDuration) {
            tempDuration = (1.0f / 10.0f) * count;
        }

        if (NULL != duration) {
            *duration = tempDuration;
        }
    }

    CFRelease(source);

    return images.copy;
}
+ (float)frameDurationAtIndex:(NSUInteger)index source:(CGImageSourceRef)source {
    float frameDuration = 0.1f;
    CFDictionaryRef cfFrameProperties = CGImageSourceCopyPropertiesAtIndex(source, index, nil);
    NSDictionary *frameProperties = (__bridge NSDictionary *) cfFrameProperties;
    NSDictionary *gifProperties = frameProperties[(NSString *) kCGImagePropertyGIFDictionary];

    NSNumber *delayTimeUnclampedProp = gifProperties[(NSString *) kCGImagePropertyGIFUnclampedDelayTime];
    if (nil != delayTimeUnclampedProp) {
        frameDuration = [delayTimeUnclampedProp floatValue];
    } else {
        NSNumber *delayTimeProp = gifProperties[(NSString *) kCGImagePropertyGIFDelayTime];
        if (nil != delayTimeProp) {
            frameDuration = [delayTimeProp floatValue];
        }
    }

    if (frameDuration < 0.011f) {
        frameDuration = 0.100f;
    }

    CFRelease(cfFrameProperties);
    return frameDuration;
}


@end
