//
//  GySdkAuthBackgroundView.m
//  GySdkLib
//
//  Created by ak on 2021/2/25.
//  Copyright © 2021 getui. All rights reserved.
//

#import "GySdkAuthBackgroundView.h"
#import <AVFoundation/AVFoundation.h>
#import "UIImage+OL.h"

@interface GySdkAuthBackgroundView()
@property(nonatomic, strong) UIImageView *imageView;
@property(nonatomic, strong) AVPlayer *player;
@property(nonatomic, strong) AVPlayerLayer *playerLayer;
@property(nonatomic, assign) GySdkAuthBackgroundMode mode;
@property(nonatomic, assign) BOOL isRepeat;
@end

@implementation GySdkAuthBackgroundView
- (instancetype)initWithMode:(GySdkAuthBackgroundMode)mode
                    resource:(id)resource
                      repeat:(BOOL)repeat{
    self = [super initWithFrame:UIScreen.mainScreen.bounds];
    if (self) {
        _mode = mode;
        _isRepeat = repeat;
        switch (mode) {
            case GySdkAuthBackgroundModeVideo: {
                self.player = [AVPlayer playerWithURL:[NSURL fileURLWithPath:resource]];
                [self.layer addSublayer:self.playerLayer];
                [self.player play];
                [NSNotificationCenter.defaultCenter addObserver:self selector:@selector(playToEndTimeNotification:) name:AVPlayerItemDidPlayToEndTimeNotification object:nil];
                [NSNotificationCenter.defaultCenter addObserver:self selector:@selector(didReceiveBecomeActiveNotification:) name:UIApplicationDidBecomeActiveNotification object:nil];
            }
                break;
            case GySdkAuthBackgroundModeGif: {
                [self addSubview:self.imageView];
                NSTimeInterval duration = 0;
                UIImage *lastFrame = nil;
                NSArray<UIImage *> *array = [UIImage ol_animatedImagesWithGifPath:resource duration:&duration lastFrameImage:&lastFrame];
                self.imageView.animationDuration = duration;
                self.imageView.image = lastFrame;
                self.imageView.animationImages = array;
                self.imageView.animationRepeatCount = 1 - repeat;
                [self.imageView startAnimating];
            }
                break;
            case GySdkAuthBackgroundModeImage:
                self.imageView.image = resource;
                [self addSubview:self.imageView];
                break;
            default:
                break;
        }
    }
    return self;
}
- (void)playToEndTimeNotification:(NSNotification *)notication {
    if (_mode != GySdkAuthBackgroundModeVideo) {
        return;
    }
    if (_isRepeat) {
        [self.player seekToTime:kCMTimeZero];
        [self.player play];
    }
}
- (void)didReceiveBecomeActiveNotification:(NSNotification *)notication {
    if (_mode != GySdkAuthBackgroundModeVideo) {
        return;
    }
    [self.player play];
}
- (void)layoutSubviews {
    [super layoutSubviews];
    if (_mode == GySdkAuthBackgroundModeVideo) {
        self.playerLayer.frame = self.bounds;
    } else if (_mode == GySdkAuthBackgroundModeImage || _mode == GySdkAuthBackgroundModeGif) {
        self.imageView.frame = self.bounds;
    }
}
- (UIImageView *)imageView {
    if (!_imageView) {
        _imageView = [[UIImageView alloc] initWithFrame:self.bounds];
        _imageView.contentMode = UIViewContentModeScaleToFill;
        _imageView.userInteractionEnabled = YES;
    }
    return _imageView;
}

- (AVPlayerLayer *)playerLayer {
    if (!_playerLayer) {
        _playerLayer = [AVPlayerLayer playerLayerWithPlayer:self.player];
        _playerLayer.frame = self.bounds;
        _playerLayer.videoGravity = AVLayerVideoGravityResizeAspectFill;
    }
    return _playerLayer;
}
- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    GTSLogDebug(@"%@ dealloc", self);
}
@end
