//
//  GySdkAuthContentView.m
//  GySdkLib
//
//  Created by ak on 2021/2/24.
//  Copyright © 2021 getui. All rights reserved.
//

#import "GySdkAuthContentView.h"
#import "GySdkAuthBackgroundView.h"
#import "GySdkAuthNavigationView.h"
#import "GYAttributedLabel.h"
@interface GySdkAuthContentView()<GYAttributedLabelDelegate>
@property(nonatomic, strong) GyAuthViewModel *viewModel;
@property(nonatomic, assign) GyOperatorType currentOperator;
@property(nonatomic, copy)   NSString *securityPhone;
@property(nonatomic, strong) GySdkAuthBackgroundView *backgroundView;
@property(nonatomic, strong) UIImageView *logoView;
@property(nonatomic, strong) UILabel *phoneNumLabel;
@property(nonatomic, strong) UILabel *sloganLabel;
@property(nonatomic, strong) UIView *termsContentView;
@property(nonatomic, strong) GYAttributedLabel *termsLabel;
@property(nonatomic, strong) NSMutableArray<GyAuthPrivacyItem *> *terms;//隐私协议
@property(nonatomic, weak) UIView *parentView;
@end

@implementation GySdkAuthContentView

- (instancetype)initWithViewModel:(GyAuthViewModel *)viewModel
                  currentOperator:(GyOperatorType)currentOperator
                    securityPhone:(NSString *)securityPhone {
    
    CGRect frame = UIScreen.mainScreen.bounds;
    if (viewModel.isPopup) {
        frame = [GySdkUtils centerXRectMake:viewModel.popupRect
                                          y:(frame.size.height - kGySdk_UI_Popup_Size.height)/2
                                defaultSize:kGySdk_UI_Popup_Size
                                 parentSize:frame.size
                                isLandscape:viewModel.isLandscape];
    }
    self = [super initWithFrame:frame];
    if (self) {
        _parentView = self;
        _viewModel = viewModel;
        _currentOperator = currentOperator;
        _securityPhone = securityPhone.length > 0 ? securityPhone : @"";
        [self addSubview:self.backgroundView];
        [self addSubview:self.navigationView];
        [self addSubview:self.customAreaView];
        [self addSubview:self.logoView];
        [self addSubview:self.phoneNumLabel];
        [self addSubview:self.switchAccountButton];
        [self addSubview:self.loginButton];
        [self addSubview:self.sloganLabel];
        [self addSubview:self.termsContentView];
        [self.termsContentView addSubview:self.checkBoxButton];
        [self.termsContentView addSubview:self.termsLabel];
        if (viewModel.isPopup) {
            [self addSubview:self.popupCloseButton];
            [self setupPopupCorner];
        }
    }
    return self;
}

- (void)setupOffset {
    BOOL isPortrait = UIInterfaceOrientationIsPortrait([UIApplication sharedApplication].statusBarOrientation);
    if (_viewModel.isPopup) {
        dfLogoYOffset = 29;
        dfPNYOffset = 110;
        dfSwitchAccountYOffset = 159;
        dfAuthBtnYOffset = 193;
        dfSloganYOffset = 244;
        dfTermsYOffset = 291;
        dfAlertYOffset = 233;
        designY = isPortrait ? 896 : 414;
        designX = isPortrait ? 414 : 896;
    } else {
        dfLogoYOffset = isPortrait ? 190 : 53;
        dfPNYOffset = isPortrait ? 346 : 163;
        dfSwitchAccountYOffset = isPortrait ? 430.5f : 270/*212*/;
        dfAuthBtnYOffset = isPortrait ? 518 : 257;
        dfSloganYOffset = isPortrait ? 601 : 320;
        dfTermsYOffset = isPortrait ? 827 : 375;
        dfAlertYOffset = isPortrait ? 789 : 307;
        designY = isPortrait ? 896 : 414;
        designX = isPortrait ? 414 : 896;
    }
}
- (void)updateFrame {
    [self setupOffset];
    CGSize parentSize = self.bounds.size;
//    CGFloat scale = [self setupScale];
    self.backgroundView.frame = self.bounds;

    CGFloat naviHeightOffset = _viewModel.naviHidden ? 0 : 44;
    BOOL isPopup = self.viewModel.isPopup;
    CGFloat yPercent = isPopup ? 1 : kGYScreenHeight / designY;
    CGFloat xPercent = isPopup ? 1 : kGYScreenWidth / designX;

    CGFloat statusHeight = [[UIApplication sharedApplication] statusBarFrame].size.height;
    CGFloat navigationContentHeight = 44;
    // 自定义UI起点
    CGFloat subviewsOrigin = statusHeight + navigationContentHeight;
    if (_viewModel.isPopup) {
        statusHeight = 0;
        navigationContentHeight = 32;
        subviewsOrigin = 0;
    }
    // 导航
//    CGFloat naviY = _viewModel.isPopup ? -10 : 0;
    self.navigationView.frame = CGRectMake(0, 0, parentSize.width, statusHeight + navigationContentHeight);
    [self.navigationView updateContentHeight:navigationContentHeight];
    
    //自定义VIEW
    //    self.customAreaView.frame = self.bounds;
    if (_viewModel.isPopup) {
        self.customAreaView.frame = CGRectMake(0, 20, parentSize.width, parentSize.height - statusHeight);
    } else {
        self.customAreaView.frame = CGRectMake(0, statusHeight + naviHeightOffset, parentSize.width, parentSize.height - (statusHeight + naviHeightOffset));
    }
    
//    CGFloat logoY = subviewsOrigin+75*scale;
    CGFloat logoY = dfLogoYOffset * yPercent;
    self.logoView.frame = [GySdkUtils centerXRectMake:_viewModel.logoRect
                                                    y:logoY
                                          defaultSize:kGySdk_UI_Logo_Size
                                           parentSize:parentSize
                                          isLandscape:_viewModel.isLandscape];
//    CGFloat phoneNumY = logoY+kGySdk_UI_Logo_Size.height+65*scale;
    CGFloat phoneNumY = dfPNYOffset * yPercent;
    CGSize phonesize = [GySdkUtils bounding:self.phoneNumLabel.text maxSize:self.frame.size minSize:kGySdk_UI_PhoneNum_Size font:self.phoneNumLabel.font];
    
    self.phoneNumLabel.frame = [GySdkUtils centerXRectMake:_viewModel.phoneNumRect
                                                         y:phoneNumY
                                               defaultSize:phonesize
                                                parentSize:parentSize
                                               isLandscape:_viewModel.isLandscape];
    
    CGSize switchsize = [GySdkUtils bounding:self.switchAccountButton.titleLabel.text maxSize:self.frame.size minSize:kGySdk_UI_SwitchAccount_Size font:self.switchAccountButton.titleLabel.font];

    CGFloat switchY = dfSwitchAccountYOffset * yPercent;
    self.switchAccountButton.frame = [GySdkUtils centerXRectMake:_viewModel.switchButtonRect
                                                               y:switchY
                                                     defaultSize:switchsize
                                                      parentSize:parentSize
                                                     isLandscape:_viewModel.isLandscape];

    CGFloat loginY = dfAuthBtnYOffset * yPercent;
    CGFloat loginW = (_viewModel.isPopup ? 260 : (320 * xPercent));
    
    self.loginButton.frame = [GySdkUtils centerXRectMake:_viewModel.authButtonRect
                                                       y:loginY
                                             defaultSize:CGSizeMake(loginW, 42)
                                              parentSize:parentSize
                                             isLandscape:_viewModel.isLandscape];

    CGFloat sloganY = dfSloganYOffset * yPercent;
    self.sloganLabel.frame = [GySdkUtils centerXRectMake:_viewModel.sloganRect
                                                       y:sloganY
                                             defaultSize:kGySdk_UI_Slogan_Size
                                              parentSize:parentSize
                                             isLandscape:_viewModel.isLandscape];
    CGSize checkSize = kGySdk_UI_CheckBox_Size;
    if ([GySdkUtils sizeValid:_viewModel.checkBoxSize]) {
        checkSize = _viewModel.checkBoxSize;
    }
    // 设置隐私协议frame
    self.checkBoxButton.frame = CGRectMake(0, 2, checkSize.width, checkSize.height);
    CGFloat termsLabelX = CGRectGetMaxX(self.checkBoxButton.frame) + 2;
    
    CGFloat termSpace = _viewModel.isPopup ? 20 : 48;
    if (_viewModel.termsRect.portraitLeftXOffset > 0) {
        termSpace = _viewModel.termsRect.portraitLeftXOffset;
    }
    CGSize termSize = CGSizeZero;
    if (_viewModel.termsRect.size.width > 0 && _viewModel.termsRect.size.height > 0) {
        termSize = _viewModel.termsRect.size;
    } else {
        ///计算文本区域的宽度
//        CGFloat maxWidth = MIN(self.bounds.size.width - termSpace * 2 - termsLabelX, 335);
        CGFloat maxWidth = self.bounds.size.width - termSpace * 2 - termsLabelX;
        // 高度计算
        CGSize termLabelSize = [GYAttributedLabel sizeThatFitsAttributedString:_termsLabel.attributedText
                                                               withConstraints:CGSizeMake(maxWidth, CGFLOAT_MAX)
                                                        limitedToNumberOfLines:0];
        termSize = CGSizeMake(termsLabelX + termLabelSize.width, termLabelSize.height);
    }
    
    if (termSize.height < kGySdk_UI_Term_Min_height) {
        termSize = CGSizeMake(termSize.width, kGySdk_UI_Term_Min_height);
    }
    
    self.termsLabel.frame = CGRectMake(termsLabelX, 0, termSize.width - termsLabelX, termSize.height);
//    CGFloat termY = self.bounds.size.height - termSize.height - kGySdk_UI_Term_Bottom_Space * scale;
    CGFloat bottomSpace = self.bounds.size.height - dfTermsYOffset * yPercent - termSize.height;
    if (bottomSpace < 0) {
        bottomSpace = bottomSpace * -1;
    } else {
        bottomSpace = 0;
    }
    CGFloat termY = dfTermsYOffset * yPercent - bottomSpace;
    self.termsContentView.frame = [GySdkUtils centerXRectMake:_viewModel.termsRect
                                                            y:termY
                                                  defaultSize:termSize
                                                   parentSize:parentSize
                                                  isLandscape:_viewModel.isLandscape];
    if (_viewModel.isPopup) {
        CGFloat rightOffset = _viewModel.closePopupRightOffset ? _viewModel.closePopupRightOffset.floatValue : -8;
        CGFloat popupCloseY = _viewModel.closePopupTopOffset ? _viewModel.closePopupTopOffset.floatValue : 11;
        self.popupCloseButton.frame = CGRectMake(self.bounds.size.width - _viewModel.closePopupSize.width + rightOffset, popupCloseY, _viewModel.closePopupSize.width, _viewModel.closePopupSize.height);
    }
}

- (void)setupPopupCorner {
    if (_viewModel.popupCornerRadius <= 0) {
        return;
    }
    if (_viewModel.popupRectCorners.count > 0) {
        UIRectCorner corners = 0;
        NSUInteger count = _viewModel.popupRectCorners.count > 4 ? 4 : _viewModel.popupRectCorners.count;
        for (NSUInteger i = 0; i < count; i++) {
            UIRectCorner item = _viewModel.popupRectCorners[i].unsignedIntegerValue;
            corners = corners | item;
        }
        UIBezierPath *bezierPath = [UIBezierPath bezierPathWithRoundedRect:self.bounds byRoundingCorners:corners cornerRadii:CGSizeMake(_viewModel.popupCornerRadius, _viewModel.popupCornerRadius)];
        CAShapeLayer *maskLayer = [[CAShapeLayer alloc] init];
        maskLayer.frame = self.bounds;
        maskLayer.path = bezierPath.CGPath;
        self.layer.mask = maskLayer;
    } else {
        self.layer.cornerRadius = _viewModel.popupCornerRadius;
        self.clipsToBounds = YES;
    }
}

/// 隐私协议点击回调
- (void)attributedLabel:(GYAttributedLabel *)label didSelectLinkWithURL:(NSURL *)url {
    u_int i = (u_int) [url.host integerValue];
    if (i > self.terms.count - 1) {
        @throw [[NSException alloc] initWithName:NSInvalidArgumentException reason:[NSString stringWithFormat:@"privacy item's url or link is invalid, index: %d", i] userInfo:@{}];;
        return;
    }
    GyAuthPrivacyItem *item = self.terms[i];
    if ([item url] == nil) {
        @throw [[NSException alloc] initWithName:NSInvalidArgumentException reason:[NSString stringWithFormat:@"privacy item's url or link is invalid, index: %d", i] userInfo:@{}];;
        return;
    }
    F_GtcSafeBlockInMainQueue(self.termBlock, item);
}

- (void)checkBoxAction:(UIButton *)sender {
    sender.selected = !sender.selected;
    [self updateLoginBtn:sender.selected];
    F_GtcSafeBlockInMainQueue(self.viewModel.clickCheckboxBlock, sender.selected);
}

- (void)updateLoginBtn:(BOOL)enable {
    if (enable) {
        [self.loginButton setBackgroundImage:_viewModel.authButtonImages[0] forState:UIControlStateNormal];
    } else {
        [self.loginButton setBackgroundImage:_viewModel.authButtonImages[1] forState:UIControlStateNormal];
    }
}

//- (CGFloat)setupScale {
//    // 不同设备适配
//    //    CGFloat deviceScale = MAX(kGYScreenHeight, kGYScreenWidth) / 667.0;
//    CGFloat deviceScale = MAX(kGYScreenHeight, kGYScreenWidth) / designY;
//    //    CGFloat widthScale = kGYScreenWidth / designX;
//    //    CGFloat heightScale = kGYScreenHeight / designY;
//    //    CGFloat rateScale = designX / designY;
//    // 弹窗高度适配
//    if (_viewModel.isPopup) {
//        deviceScale = (self.bounds.size.height / 667.0);
//    }
//    // 屏幕方向适配
//    CGFloat orientationScale = 1;
//    if (_viewModel.isLandscape) {
//        orientationScale = self.bounds.size.height / self.bounds.size.width;
//    }
//    return deviceScale * orientationScale;
//}

- (void)layoutSubviews {
    [super layoutSubviews];
    [self updateFrame];
}

- (GySdkAuthBackgroundView *)backgroundView {
    if (!_backgroundView) {
        // 优先级 视频 > gif > 图片 > 背景色
        GySdkAuthBackgroundMode mode = GySdkAuthBackgroundModeColor;
        id resource = _viewModel.backgroundColor;
        if (_viewModel.backgroundImage) {
            mode = GySdkAuthBackgroundModeImage;
            resource = _viewModel.backgroundImage;
        }
        if (_viewModel.landscapeBackgroundImage && _viewModel.isLandscape) {
            mode = GySdkAuthBackgroundModeImage;
            resource = _viewModel.landscapeBackgroundImage;
        }
        if (F_GtcIsStringValue_Valid(_viewModel.backgroundGifPath)) {
            mode = GySdkAuthBackgroundModeGif;
            resource = _viewModel.backgroundGifPath;
        }
        if (F_GtcIsStringValue_Valid(_viewModel.backgroundVideoPath)) {
            mode = GySdkAuthBackgroundModeVideo;
            resource = _viewModel.backgroundVideoPath;
        }
        _backgroundView = [[GySdkAuthBackgroundView alloc] initWithMode:mode resource:resource repeat:_viewModel.allowGifOrVideoPlayRepeat];
        _backgroundView.tag = TAG_BACKGROUND_IMAGE;
        _backgroundView.frame = self.bounds;
        _backgroundView.backgroundColor = _viewModel.backgroundColor;
    }
    return _backgroundView;
}

- (GySdkAuthNavigationView *)navigationView {
    if (!_navigationView) {
        _navigationView = [[GySdkAuthNavigationView alloc] init];
        _navigationView.tag = TAG_NAVIGATION;
        _navigationView.hidden = _viewModel.naviHidden;
        _navigationView.backgroundColor = _viewModel.naviBgColor;
        _navigationView.titleLabel.attributedText = _viewModel.naviTitle;
        if (_viewModel.isPopup) {
            _navigationView.backButton.hidden = YES;
        } else {
            _navigationView.backButton.hidden = _viewModel.backButtonHidden;
            _navigationView.backButtonRect = _viewModel.backButtonRect;
            [_navigationView.backButton setImage:_viewModel.naviBackImage forState:UIControlStateNormal];
            [_navigationView setupRightControl:_viewModel.naviRightControl];
        }
    }
    return _navigationView;
}

- (UIView *)customAreaView {
    if (!_customAreaView) {
        _customAreaView = [[UIView alloc] initWithFrame:self.bounds];
        _customAreaView.tag = TAG_CUSTOM;
    }
    return _customAreaView;
}

- (UIButton *)popupCloseButton {
    if (!_popupCloseButton) {
        _popupCloseButton = [UIButton buttonWithType:UIButtonTypeCustom];
        [_popupCloseButton setImage:_viewModel.closePopupImage forState:UIControlStateNormal];
    }
    return _popupCloseButton;
}

- (UIImageView *)logoView {
    if (!_logoView) {
        _logoView = [[UIImageView alloc] init];
        _logoView.tag = TAG_LOGO;
        if (!_viewModel.appLogo) {
            @throw [[NSException alloc] initWithName:NSInvalidArgumentException reason:@"logo image can not be NULL" userInfo:@{}];
        }
        _logoView.hidden = _viewModel.logoHidden;
        _logoView.image = _viewModel.appLogo;
        if (_viewModel.logoCornerRadius > 0) {
            _logoView.layer.cornerRadius = _viewModel.logoCornerRadius;
            _logoView.clipsToBounds = YES;
        }
    }
    return _logoView;
}

- (UILabel *)phoneNumLabel {
    if (!_phoneNumLabel) {
        _phoneNumLabel = [[UILabel alloc] init];
        _phoneNumLabel.textAlignment = NSTextAlignmentCenter;
        _phoneNumLabel.font = _viewModel.phoneNumFont;
        _phoneNumLabel.textColor = _viewModel.phoneNumColor;
        _phoneNumLabel.text = _securityPhone;
        _phoneNumLabel.tag = TAG_PN;
    }
    return _phoneNumLabel;
}

- (UIButton *)switchAccountButton {
    if (!_switchAccountButton) {
        _switchAccountButton = [UIButton buttonWithType:(UIButtonTypeCustom)];
        
        [_switchAccountButton setTitle:_viewModel.switchButtonText.length > 0 ? _viewModel.switchButtonText : @"切换账号" forState:UIControlStateNormal];
        [_switchAccountButton setTitleColor:_viewModel.switchButtonColor ?: [UIColor colorWithRed:0.22 green:0.45 blue:1 alpha:1] forState:UIControlStateNormal];
        _switchAccountButton.titleLabel.font = _viewModel.switchButtonFont ?: [UIFont systemFontOfSize:15];
        _switchAccountButton.backgroundColor = _viewModel.switchButtonBackgroundColor ?: UIColor.clearColor;;
        _switchAccountButton.hidden = _viewModel.switchButtonHidden;
        _switchAccountButton.tag = TAG_EXCHANGE;
    }
    return _switchAccountButton;
}

- (UIButton *)loginButton {
    if (!_loginButton) {
        _loginButton = [UIButton buttonWithType:UIButtonTypeCustom];
        _loginButton.tag = TAG_LOGIN_BUTTON;
        if (_viewModel.authButtonImages.count != 3) {
            _viewModel.authButtonImages = @[[GySdkUtils imageWithColor:
                                             [UIColor colorWithRed:0.22 green:0.45 blue:1 alpha:1]],
                                            [GySdkUtils imageWithColor:
                                             [UIColor lightGrayColor]],
                                            [GySdkUtils imageWithColor:
                                             [UIColor colorWithRed:0.356 green:0.545 blue:1 alpha:1]]];
        }
        [_loginButton setBackgroundImage:_viewModel.authButtonImages[0] forState:UIControlStateNormal];
        // Disabled 仍要点击
        [_loginButton setBackgroundImage:_viewModel.authButtonImages[1] forState:UIControlStateDisabled];
        [_loginButton setBackgroundImage:_viewModel.authButtonImages[2] forState:UIControlStateHighlighted];
        
        _loginButton.layer.cornerRadius = _viewModel.authButtonCornerRadius;
        _loginButton.clipsToBounds = YES;
        [self updateLoginBtn:_viewModel.defaultCheckBoxState]; 
        
        NSAttributedString *text = _viewModel.authButtonTitle;
        if (!text) {
            text = [[NSAttributedString alloc] initWithString:@"一键登录"
                                            attributes:@{NSForegroundColorAttributeName:[UIColor whiteColor],
                                                         NSFontAttributeName: [UIFont systemFontOfSize:17]}];
        }
        
        [_loginButton setAttributedTitle:text forState:UIControlStateNormal];
        
    }
    return _loginButton;
}

- (UILabel *)sloganLabel {
    if (!_sloganLabel) {
        _sloganLabel = [[UILabel alloc] init];
        _sloganLabel.textAlignment = NSTextAlignmentCenter;
        _sloganLabel.textColor = _viewModel.sloganTextColor ?: [UIColor colorWithRed:0.52 green:0.54 blue:0.71 alpha:1];;
        _sloganLabel.font = _viewModel.sloganTextFont?: [UIFont systemFontOfSize:12];;
        _sloganLabel.text = [GySdkUtils operatorSlogan:_currentOperator];
        _sloganLabel.tag = TAG_SLOGAN;
    }
    return _sloganLabel;
}

- (UIView *)termsContentView {
    if (!_termsContentView) {
        _termsContentView = [[UIView alloc] init];
        _termsContentView.tag = TAG_TERMS_ITEM;
    }
    return _termsContentView;
}

- (UIButton *)checkBoxButton {
    if (!_checkBoxButton) {
        _checkBoxButton = [UIButton buttonWithType:UIButtonTypeCustom];
        _checkBoxButton.contentVerticalAlignment = UIControlContentVerticalAlignmentTop;
        _checkBoxButton.adjustsImageWhenHighlighted = NO;
        [_checkBoxButton setImage:_viewModel.uncheckedImage forState:UIControlStateNormal];
        [_checkBoxButton setImage:_viewModel.checkedImage forState:UIControlStateSelected];
        _checkBoxButton.selected = _viewModel.defaultCheckBoxState;
        [_checkBoxButton addTarget:self action:@selector(checkBoxAction:) forControlEvents:UIControlEventTouchUpInside];
        _checkBoxButton.tag = TAG_TERMS_ITEM_CHECKBOX;
    }
    return _checkBoxButton;
}

- (GYAttributedLabel *)termsLabel {
    if (!_termsLabel) {
        _termsLabel = [[GYAttributedLabel alloc] initWithFrame:CGRectZero];
        _termsLabel.tag = TAG_TERMS_ITEM_LABEL;
        _termsLabel.enabledTextCheckingTypes = NSTextCheckingTypeLink;
        _termsLabel.font = [UIFont systemFontOfSize:12];
        _termsLabel.numberOfLines = 0;
        _termsLabel.delegate = self;
        // 隐私协议样式
        NSDictionary<NSAttributedStringKey, id> *attr = _viewModel.privacyTermsAttributes;
        NSMutableParagraphStyle *paragraphStyle = attr[NSParagraphStyleAttributeName];
        if (paragraphStyle == nil) {
            paragraphStyle = [[NSMutableParagraphStyle alloc] init];
            paragraphStyle.lineSpacing = 1.33;
            paragraphStyle.alignment = NSTextAlignmentLeft;
            paragraphStyle.paragraphSpacing = 0.0;
            paragraphStyle.lineBreakMode = NSLineBreakByWordWrapping;
            paragraphStyle.firstLineHeadIndent = 0.0;
        }
        if (attr == nil) {
            attr = @{
                NSFontAttributeName: [UIFont systemFontOfSize:12],
                NSParagraphStyleAttributeName: paragraphStyle,
                NSUnderlineStyleAttributeName: @(NSUnderlineStyleNone),
                NSForegroundColorAttributeName: [UIColor blueColor]};
        }
        _termsLabel.lineSpacing = paragraphStyle.lineSpacing;
        _termsLabel.textColor = _viewModel.termTextColor?: [UIColor colorWithRed:0.52 green:0.54 blue:0.71 alpha:1];;
        _termsLabel.textAlignment = _viewModel.termsAlignment ?: NSTextAlignmentLeft;
        _termsLabel.linkAttributes = attr;
        _termsLabel.activeLinkAttributes = _viewModel.activeLinkAttributes;
        
        GyAuthPrivacyItem *defaultPrivacy = [GySdkUtils operatorPrivacy:_currentOperator hasQuotationMark:_viewModel.hasQuotationMarkOnCarrierProtocol];
        NSMutableArray<GyAuthPrivacyItem *> *totalTerms = [NSMutableArray arrayWithArray:@[defaultPrivacy]];
        [totalTerms addObjectsFromArray:_viewModel.additionalPrivacyTerms];
        // 隐私条款排序
        [totalTerms sortUsingComparator:^NSComparisonResult(GyAuthPrivacyItem *obj1, GyAuthPrivacyItem *obj2) {
            return obj1.index < obj2.index ? NSOrderedAscending : (obj1.index > obj2.index ? NSOrderedDescending : NSOrderedSame);
        }];
        self.terms = [totalTerms copy];
        
        if (_viewModel.auxiliaryPrivacyWords.count != 4) {
            _viewModel.auxiliaryPrivacyWords = @[@"登录即同意", @"和", @"、", @"并使用本机号码登录"];
        }

        // 隐私条款字符串拼接
        NSString *totalTermText = @"";
        for (int i = 0; i < totalTerms.count; i++) {
            NSString *privacyWord = _viewModel.auxiliaryPrivacyWords[i < 3 ? i : 2];
            totalTermText = [totalTermText stringByAppendingFormat:@"%@%@",privacyWord,[totalTerms[i] text]];
        }
        totalTermText = [totalTermText stringByAppendingFormat:@"%@", _viewModel.auxiliaryPrivacyWords.lastObject];
        _termsLabel.text = totalTermText;
        for (int i = 0; i < totalTerms.count; i++) {
            if (F_GtcIsStringValue_Empty([totalTerms[i] text])) {
                @throw [[NSException alloc] initWithName:NSInvalidArgumentException reason:[NSString stringWithFormat:@"privacy item is not valid, index: %d", i] userInfo:nil];
            }
            NSRange range = [totalTermText rangeOfString:[totalTerms[i] text]];
            if (range.location != NSNotFound) {
                [_termsLabel addLinkToURL:[[NSURL alloc] initWithString:[NSString stringWithFormat:@"terms://%d", i]] withRange:range];
            }
        }
        [_termsLabel sizeToFit];
        
    }
    return _termsLabel;
}

- (void)dealloc {
    [self.customAreaView.subviews enumerateObjectsUsingBlock:^(__kindof UIView * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        [obj removeFromSuperview];
    }];
    GTSLogDebug(@"%@ dealloc", self);
}
@end

