//
//  GySdkAuthNavigationView.m
//  GySdkLib
//
//  Created by ak on 2021/2/26.
//  Copyright © 2021 getui. All rights reserved.
//

#import "GySdkAuthNavigationView.h"

@interface GySdkAuthNavigationView()
@property(nonatomic, strong) UIView *contentView;
@property(nonatomic, strong) UIView *naviRightControl;

@end

@implementation GySdkAuthNavigationView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.contentView = [[UIView alloc] init];
        self.contentView.tag = TAG_NAVIGATION_ITEM;
        [self addSubview:self.contentView];
        self.backButton = [UIButton buttonWithType:UIButtonTypeCustom];
        self.backButton.tag = TAG_NAVIGATION_ITEM_BACK;
        [self.contentView addSubview:self.backButton];
        self.titleLabel = [[UILabel alloc] init];
        self.titleLabel.tag = TAG_NAVIGATION_ITEM_TITLE;
        self.titleLabel.textAlignment = NSTextAlignmentCenter;
        [self.contentView addSubview:self.titleLabel];
    }
    return self;
}
- (void)updateContentHeight:(CGFloat)height {
    self.contentView.frame = CGRectMake(0, self.bounds.size.height - height, self.bounds.size.width, height);
    CGSize backSize = [GySdkUtils sizeMake:self.backButtonRect defaultSize:CGSizeMake(44, height)];;
    CGPoint backPoint = [GySdkUtils originMake:self.backButtonRect
                                 defaultOrigin:CGPointMake(0, (height-backSize.height)/2)
                                    parentSize:self.contentView.frame.size
                                   isLandscape:NO];
    self.backButton.frame = CGRectMake(backPoint.x, backPoint.y, backSize.width, backSize.height);
    CGFloat titleWidth = self.bounds.size.width*2/5;
    self.titleLabel.frame = CGRectMake((self.bounds.size.width - titleWidth)/2, 0, titleWidth, height);
    if (self.naviRightControl) {
        CGSize rightSize = self.naviRightControl.frame.size;
        CGFloat rightHeight = rightSize.height > height ? height : rightSize.height;
        self.naviRightControl.frame = CGRectMake(self.bounds.size.width - rightSize.width - 10, (height-rightHeight)/2, self.naviRightControl.frame.size.width, rightHeight);
    }
}
- (void)setupRightControl:(nullable UIView *)control {
    if (control == nil) {
        return;
    }
    if (self.naviRightControl) {
        [self.naviRightControl removeFromSuperview];
    }
    self.naviRightControl = control;
    self.naviRightControl.tag = TAG_NAVIGATION_ITEM_RIGHT;
    [self.contentView addSubview:self.naviRightControl];
//    [self.rightControl sizeToFit];
}
- (void)dealloc {
    GTSLogDebug(@"%@ dealloc", self);
}

@end
