//
//  CommonToastHUD.m
//  Objective-C Utils
//
//  Created by 赵伟 on 15/3/4.
//  Copyright (c) 2015年 赵伟. All rights reserved.
//

#import "CommonToastHUD.h"
#import "AppDelegate.h" 
#import "MBProgressHUD.h"
#import "WaitLoadView.h"
#import <pthread.h>

#define kAppDelegate (AppDelegate *)[UIApplication sharedApplication].delegate
#define kGTProgressHUDHideTimeInterval 1.5f

@interface CommonToastHUD () {
}

@property (strong, nonatomic) MBProgressHUD *HUD;
/*
 当前正在显示的loadingHUD
 */
@property (nonatomic, strong) MBProgressHUD *activeLoadingHUD;

@end

@implementation CommonToastHUD

+ (CommonToastHUD *)sharedInstance {
    static CommonToastHUD *sharedInstance = nil;
    static dispatch_once_t predicate;
    dispatch_once(&predicate, ^{
      sharedInstance = [[self alloc] init];
    });
    return sharedInstance;
}

/* 温馨提示 */
- (void)showTips:(NSString *)message {
    if (!message || [@"" isEqualToString:message])
        return;

    UIView *superView = [UIApplication sharedApplication].keyWindow;

    MBProgressHUD *hud = [[MBProgressHUD alloc] initWithView:superView];
    [superView addSubview:hud];

    // Configure for text only and offset down
    hud.mode = MBProgressHUDModeText;
    hud.detailsLabelText = message;
    hud.detailsLabelFont = [UIFont systemFontOfSize:16];
    hud.margin = 10.f;
    hud.userInteractionEnabled = NO;
    hud.removeFromSuperViewOnHide = YES;

    [hud show:YES];
    [hud hide:YES afterDelay:2.0f];
}

/** 显示锁屏提示 - 所有提示公用一个 */
- (void)showActivityView:(NSString *)msg {
    if (_HUD) {
        [_HUD removeFromSuperview];
        _HUD = nil;
    }

    UIView *superView = [UIApplication sharedApplication].keyWindow;

    self.HUD = [[MBProgressHUD alloc] initWithView:superView];
    [superView addSubview:_HUD];

    _HUD.mode = MBProgressHUDModeIndeterminate;
    _HUD.activityIndicatorColor = [UIColor whiteColor];
    _HUD.labelText = msg;
    _HUD.margin = 20;

    _HUD.dimBackground = NO; //使背景成黑灰色，让MBProgressHUD成高亮显示
    _HUD.square = NO;        //设置显示框的高度和宽度一样
    _HUD.color = [UIColor blackColor];

    _HUD.backgroundColor = kRGBA(1, 1, 1, 0.5); // 背景颜色

    [_HUD show:YES];
}
/** 带有子标题的HUD */
- (void)showActivityViewWithTitle:(NSString *)title subTitle:(NSString *)subTitle {
    if (_HUD) {
        [_HUD removeFromSuperview];
        _HUD = nil;
    }

    UIView *superView = [UIApplication sharedApplication].keyWindow;

    self.HUD = [[MBProgressHUD alloc] initWithView:superView];
    [superView addSubview:_HUD];

    _HUD.mode = MBProgressHUDModeIndeterminate;
    _HUD.activityIndicatorColor = [UIColor blackColor];
    _HUD.labelText = title;

    _HUD.detailsLabelText = subTitle;
    _HUD.margin = 20;

    _HUD.dimBackground = NO; //使背景成黑灰色，让MBProgressHUD成高亮显示
    _HUD.square = NO;        //设置显示框的高度和宽度一样
    _HUD.color = [UIColor blackColor];

    _HUD.backgroundColor = kRGBA(1, 1, 1, 0.5); // 背景颜色

    [_HUD show:YES];
}
/** 隐藏锁屏提示 */
- (void)hideActivityView {
    [_HUD removeFromSuperview];
}
+ (void)customlizeHUD:(MBProgressHUD *)hud {
    
    hud.backgroundView.style = MBProgressHUDBackgroundStyleSolidColor;
    hud.bezelView.color = [UIColor colorWithRed:(CGFloat)0x00/255.f green:(CGFloat)0x0F/255.f blue:(CGFloat)0x1A/255.f alpha:0.9];
    hud.label.numberOfLines = 2;
    hud.label.font = [UIFont systemFontOfSize:15];
    hud.label.textColor = UIColor.whiteColor;
    hud.contentColor = UIColor.whiteColor;
}

+ (void)showToastWithMessage:(NSString *)message {
    [self showToastWithMessage:message offset:CGPointMake(0.f, 0.f)];
}

+ (void)showToastAtBottomWithMessage:(NSString *)message {
    [self showToastWithMessage:message offset:CGPointMake(0.f, CGFLOAT_MAX)];
}

+ (void)showToastWithMessage:(NSString *)message offset:(CGPoint)offset {
    if (!message || message.length == 0) {
        return;
    }
    
    [self hideAllHUD];
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:[self keyWindow] animated:YES];
    hud.mode = MBProgressHUDModeText;
    [self customlizeHUD:hud];
    hud.userInteractionEnabled = NO;
    hud.label.text = message;
    hud.offset = offset;
    [hud hideAnimated:YES afterDelay:kGTProgressHUDHideTimeInterval];
}

+ (void)showLoadingHUDWithMessage:(NSString * _Nullable)message {
    [self showLoadingHUDWithMessage:message inView:[self keyWindow]];
}

+ (void)showLoadingHUDWithMessage:(NSString * _Nullable)message inView:(UIView * _Nullable)view {
    [self hideAllHUD];
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:view animated:YES];
    [self customlizeHUD:hud];
    hud.userInteractionEnabled = NO;
    [[self sharedInstance] setActiveLoadingHUD:hud];
    hud.label.text = message;
}

+ (void)hideLoadingHUDInView:(UIView * _Nullable)view {
    if ([[self sharedInstance] activeLoadingHUD]) {
        [[[self sharedInstance] activeLoadingHUD] hideAnimated:YES];
        [[self sharedInstance] setActiveLoadingHUD:nil];
    } else {
        for (UIView *subview in view.subviews) {
            if ([subview isKindOfClass:[MBProgressHUD class]]) {
                MBProgressHUD *hud = (MBProgressHUD *)subview;
                [hud hideAnimated:YES];
            }
        }
    }
}

+ (void)hideAllHUD {
    [self hideLoadingHUDInView:[self keyWindow]];
}

+ (UIWindow *)keyWindow {
    UIWindow *window = [UIApplication sharedApplication].keyWindow;
    if (!window) {
        window = [[UIApplication sharedApplication].windows firstObject];
    }
    return window;
}


//MARK: GY Custom
+ (void)hideAllAndTip:(NSString*)msg {
    [CommonToastHUD hideAllHUD];
    [[CommonToastHUD sharedInstance] showTips:msg];
}
@end
