//
//  CustomLoginView.m
//  GyDemo
//
//  Created by ak on 2021/5/19.
//  Copyright © 2021 getui. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CustomLoginView.h"
#import "WechatView.h"

@interface CustomLoginView()<TTTAttributedLabelDelegate>
@property (nonatomic, weak) IBOutlet UIView *contentView;
@property (weak, nonatomic) IBOutlet UIButton *closeBtn;
@property (strong, nonatomic) WechatView *chatView;
@end

@implementation CustomLoginView

- (void)awakeFromNib {
    [super awakeFromNib];

    // 隐私协议样式
    self.termLabel.enabledTextCheckingTypes = NSTextCheckingTypeLink;
    self.termLabel.font = [UIFont systemFontOfSize:12];
    self.termLabel.numberOfLines = 0;
    self.termLabel.delegate = self;
    
    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    paragraphStyle.lineSpacing = 7;
    paragraphStyle.alignment = NSTextAlignmentLeft;
    paragraphStyle.paragraphSpacing = 0.0;
    paragraphStyle.lineBreakMode = NSLineBreakByWordWrapping;
    paragraphStyle.firstLineHeadIndent = 0.0;
    
    NSDictionary<NSAttributedStringKey, id> *attr =  @{
        NSForegroundColorAttributeName: UIColor.orangeColor,
        NSParagraphStyleAttributeName: paragraphStyle,
        NSFontAttributeName: [UIFont systemFontOfSize:12]
    };
    
    self.termLabel.lineSpacing = 7;
    self.termLabel.textColor = [UIColor colorWithRed:0.52 green:0.54 blue:0.71 alpha:1];
    self.termLabel.textAlignment = NSTextAlignmentLeft;
    self.termLabel.linkAttributes = attr;
    
    self.chatView = [[[UINib nibWithNibName:@"WechatView" bundle:nil] instantiateWithOwner:nil options:nil] firstObject];
    [self.contentView addSubview:self.chatView];
    
    [self.checkboxBtn setSelected:NO];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    self.loginBtn.layer.cornerRadius = self.loginBtn.bounds.size.height * 0.5;
    self.loginBtn.clipsToBounds = YES;
    self.chatView.frame = self.contentView.bounds;
    [Utils addGradient:self.loginBtn frame:self.loginBtn.bounds];
}

- (void)render {
    GyContentModel *model = [GyContentModel currentModel];
    self.pnLabel.text = model.pn;
    self.sloganLabel.text = model.slogan;
    self.termLabel.text = model.term;
    [self updateCheckBoxState];

    // 隐私条款字符串拼接
    NSString *termText = [NSString stringWithFormat:@"登录即同意%@并使用本机号码登录", model.term];
    self.termLabel.text = termText;
    
    NSRange range = [termText rangeOfString:model.term];
    if (range.location != NSNotFound) {
        [self.termLabel addLinkToURL:[[NSURL alloc] initWithString:[NSString stringWithFormat:@"%@", model.link]] withRange:range];
    }
    [self.termLabel sizeToFit];
}

- (IBAction)loginClick:(id)sender {
    
}

- (IBAction)closeClick:(id)sender {
    [GeYanSdk closeAuthVC:YES completion:nil];
}

- (IBAction)checked:(UIButton*)checkbox {
    checkbox.selected = !checkbox.selected;
    [self updateCheckBoxState];
}

- (void)updateCheckBoxState {
    NSString *image = self.checkboxBtn.selected ? @"TYRZResource.bundle/check_12x12_" : @"TYRZResource.bundle/uncheck_12x12_";
    [self.checkboxBtn setImage:[UIImage imageNamed:image] forState:UIControlStateNormal];
}

/// 隐私协议点击回调
- (void)attributedLabel:(TTTAttributedLabel *)label didSelectLinkWithURL:(NSURL *)url {
    NSLog(@"%@", url);
    if (self.jumpWebClick) {
        self.jumpWebClick(url);
    }
}

//MARK: - Layout

- (void)layoutFullScreen {
    self.frame = [UIScreen mainScreen].bounds;
    [self addCorner:0];
    [self addBorder:0 color:[UIColor blueColor]];
    __weak CustomLoginView *weakSelf = self;
    
    CGFloat yPercent = kScreenHeight / 896;//以iPhone11 为适配标准
    [self.logoImageView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.width.height.equalTo(@70);
        make.centerX.equalTo(weakSelf);
        make.top.equalTo(@(170*yPercent));
    }];
    [self.pnLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(weakSelf);
        make.top.equalTo(weakSelf.logoImageView.mas_bottom).offset(30*yPercent);
        make.height.equalTo(@(40));
    }];
    [self.sloganLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(weakSelf);
        make.top.equalTo(weakSelf.pnLabel.mas_bottom).offset(20*yPercent);
        make.height.equalTo(@(30));
    }];
    [self.loginBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(weakSelf).offset(40*yPercent);
        make.right.equalTo(weakSelf).offset(-40*yPercent);
        make.top.equalTo(weakSelf.sloganLabel.mas_bottom).offset(60*yPercent);
        make.height.equalTo(@(48));
    }];
    [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(weakSelf).offset(40*yPercent);
        make.right.equalTo(weakSelf).offset(-40*yPercent);
        make.top.equalTo(weakSelf.loginBtn.mas_bottom).offset(30*yPercent);
        make.height.equalTo(@(200*yPercent));
    }];
    [self.termView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(weakSelf).offset(40*yPercent);
        make.right.equalTo(weakSelf).offset(-40*yPercent);
        make.height.equalTo(@(50));
        make.bottom.equalTo(weakSelf).offset(kIsiPhoneX ? -30*yPercent : -5);
    }];
    [self.checkboxBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.termView.mas_top);
        make.left.equalTo(weakSelf.termView.mas_left).offset(0);
        make.width.height.equalTo(@(30));
    }];
    [self.termLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.termView.mas_top);
        make.left.equalTo(weakSelf.checkboxBtn.mas_right).offset(0);
        make.bottom.right.equalTo(weakSelf.termView);
    }];
    [self.closeBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.width.height.equalTo(@40);
        make.top.right.equalTo(weakSelf);
    }];
    self.closeBtn.hidden = YES;
}

- (void)layoutFloatingWindow {
    CGFloat windowH = 540;
    self.frame = CGRectMake(0, kScreenHeight, kScreenWidth, windowH);
    [self addCorner:5];
    [self addBorder:0 color:[UIColor blueColor]];
    __weak CustomLoginView *weakSelf = self;
    
    CGFloat yPercent = kScreenHeight / 896;//以iPhone11 为适配标准
    [self.logoImageView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.width.height.equalTo(@70);
        make.centerX.equalTo(weakSelf);
        make.top.equalTo(@(50*yPercent));
    }];
    [self.pnLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(weakSelf);
        make.top.equalTo(weakSelf.logoImageView.mas_bottom).offset(30*yPercent);
        make.height.equalTo(@(40));
    }];
    [self.sloganLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(weakSelf);
        make.top.equalTo(weakSelf.pnLabel.mas_bottom).offset(0*yPercent);
        make.height.equalTo(@(30));
    }];
    [self.loginBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(weakSelf).offset(40*yPercent);
        make.right.equalTo(weakSelf).offset(-40*yPercent);
        make.top.equalTo(weakSelf.sloganLabel.mas_bottom).offset(40*yPercent);
        make.height.equalTo(@(48));
    }];
    [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(weakSelf).offset(40*yPercent);
        make.right.equalTo(weakSelf).offset(-40*yPercent);
        make.top.equalTo(weakSelf.loginBtn.mas_bottom).offset(30*yPercent);
        make.height.equalTo(@(100*yPercent));
    }];
    [self.termView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(weakSelf).offset(40*yPercent);
        make.right.equalTo(weakSelf).offset(-40*yPercent);
        make.height.equalTo(@(50));
        make.bottom.equalTo(weakSelf).offset(kIsiPhoneX ? -30*yPercent : -5);
    }];
    [self.checkboxBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.termView.mas_top);
        make.left.equalTo(weakSelf.termView.mas_left).offset(0);
        make.width.height.equalTo(@(30));
    }];
    [self.termLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.termView.mas_top);
        make.left.equalTo(weakSelf.checkboxBtn.mas_right).offset(0);
        make.bottom.right.equalTo(weakSelf.termView);
    }];
    [self.closeBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.width.height.equalTo(@50);
        make.top.right.equalTo(weakSelf);
    }];
    self.closeBtn.hidden = NO;
}

- (void)layoutPopup {
    CGFloat popW = 350;
    CGFloat popH = 540;
    self.frame = CGRectMake(0, 0, popW, popH);
    self.center = CGPointMake(kScreenWidth*0.5, kScreenHeight*0.5);
    [self addCorner:5];
    [self addBorder:0 color:[UIColor blueColor]];
    __weak CustomLoginView *weakSelf = self;
    
    CGFloat yPercent = kScreenHeight / 896;//以iPhone11 为适配标准
    [self.logoImageView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.width.height.equalTo(@70);
        make.centerX.equalTo(weakSelf);
        make.top.equalTo(@(50*yPercent));
    }];
    [self.pnLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(weakSelf);
        make.top.equalTo(weakSelf.logoImageView.mas_bottom).offset(30*yPercent);
        make.height.equalTo(@(40));
    }];
    [self.sloganLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(weakSelf);
        make.top.equalTo(weakSelf.pnLabel.mas_bottom).offset(0*yPercent);
        make.height.equalTo(@(30));
    }];
    [self.loginBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(weakSelf).offset(40*yPercent);
        make.right.equalTo(weakSelf).offset(-40*yPercent);
        make.top.equalTo(weakSelf.sloganLabel.mas_bottom).offset(40*yPercent);
        make.height.equalTo(@(48));
    }];
    [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(weakSelf).offset(40*yPercent);
        make.right.equalTo(weakSelf).offset(-40*yPercent);
        make.top.equalTo(weakSelf.loginBtn.mas_bottom).offset(30*yPercent);
        make.height.equalTo(@(100*yPercent));
    }];
    [self.termView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(weakSelf).offset(40*yPercent);
        make.right.equalTo(weakSelf).offset(-40*yPercent);
        make.height.equalTo(@(50));
        make.bottom.equalTo(weakSelf).offset(kIsiPhoneX ? -30*yPercent : -5);
    }];
    [self.checkboxBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.termView.mas_top);
        make.left.equalTo(weakSelf.termView.mas_left).offset(0);
        make.width.height.equalTo(@(30));
    }];
    [self.termLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.termView.mas_top);
        make.left.equalTo(weakSelf.checkboxBtn.mas_right).offset(0);
        make.bottom.right.equalTo(weakSelf.termView);
    }];
    [self.closeBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.width.height.equalTo(@50);
        make.top.right.equalTo(weakSelf);
    }];
    self.closeBtn.hidden = NO;
}

- (void)layoutLandscape {
    self.frame = CGRectMake(0, 0, kScreenHeight, kScreenWidth);
    [self addCorner:0];
    [self addBorder:0 color:[UIColor blueColor]];
    __weak CustomLoginView *weakSelf = self;
    
    CGFloat yPercent = kScreenHeight / 896;//以iPhone11 为适配标准
    [self.logoImageView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.width.height.equalTo(@70);
        make.centerX.equalTo(weakSelf);
        make.top.equalTo(@(30*yPercent));
    }];
    [self.pnLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(weakSelf);
        make.top.equalTo(weakSelf.logoImageView.mas_bottom).offset(10*yPercent);
        make.height.equalTo(@(40));
    }];
    [self.sloganLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(weakSelf);
        make.top.equalTo(weakSelf.pnLabel.mas_bottom).offset(10*yPercent);
        make.height.equalTo(@(30));
    }];
    [self.loginBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.sloganLabel.mas_bottom).offset(10*yPercent);
        make.centerX.equalTo(weakSelf);
        make.width.equalTo(@(200*yPercent));
        make.height.equalTo(@(48));
    }];
    [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.loginBtn.mas_bottom).offset(10*yPercent);
        make.centerX.equalTo(weakSelf);
        make.width.equalTo(@(200*yPercent));
        make.height.equalTo(@(120*yPercent));
    }];
    [self.termView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(weakSelf).offset(40*yPercent);
        make.right.equalTo(weakSelf).offset(-40*yPercent);
        make.height.equalTo(@(30));
        make.bottom.equalTo(weakSelf).offset(kIsiPhoneX ? -30*yPercent : -5);
    }];
    [self.checkboxBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.termView.mas_top);
        make.left.equalTo(weakSelf.termView.mas_left).offset(0);
        make.width.height.equalTo(@(30));
    }];
    [self.termLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.termView.mas_top);
        make.left.equalTo(weakSelf.checkboxBtn.mas_right).offset(0);
        make.bottom.right.equalTo(weakSelf.termView);
    }];
    [self.closeBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.width.height.equalTo(@40);
        make.top.right.equalTo(weakSelf);
    }];
    self.closeBtn.hidden = YES;
}
@end
