//
//  GyCheckController.m
//  GyDemo
//
//  Created by ak on 2021/3/2.
//  Copyright © 2021 getui. All rights reserved.
//

#import "CheckController.h"
#import "SuccessController.h"

@interface CheckController ()
@property(nonatomic, strong) UITextField *textField;
@end

@implementation CheckController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupView]; 
}

- (void)verifyAction {
    [self.view endEditing:YES];
    NSString *pn = self.textField.text;
    if (pn.length != 11 || ![[pn substringToIndex:1] isEqualToString:@"1"]) {
        NSLog(@"Demo checkPNValid failed");
        [CommonToastHUD hideAllAndTip:@"请输入正确的11位手机号码!"];
        return;
    }
    [CommonToastHUD showLoadingHUDWithMessage:nil];
    
    __weak CheckController *weakSelf = self;
    [GeYanSdk getPhoneVerifyTokenCallback:^(NSDictionary *result) {
        NSLog(@"getPhoneVerifyToken: %@ %@", result, result[@"msg"]);
        NSString *token = result[@"token"];
        if (token.length > 0) {
            [GeYanSdk checkPhoneNumber:pn andCallback:^(NSDictionary * _Nullable verifyDictionary) {
                NSLog(@"checkPhoneNumber: %@", verifyDictionary);
                if ([verifyDictionary[@"code"] isEqualToNumber:@30000]) {
                    [CommonToastHUD hideAllHUD];
                    SuccessController *ctrl = [[SuccessController alloc] init];
                    ctrl.tipTitle = @"认证一致";
                    ctrl.pn = pn;
                    [weakSelf.navigationController pushViewController:ctrl animated:YES];
                } else {
                    [CommonToastHUD hideAllAndTip:[Utils dic2Str:verifyDictionary]];
                }
            }];
        } else {
            [CommonToastHUD hideAllAndTip:[Utils dic2Str:result]];
        }
    }];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.navigationController setNavigationBarHidden:YES animated:animated];
}

- (void)setupView {
    self.view.backgroundColor = UIColor.whiteColor;
    self.navigationController.navigationBar.tintColor = UIColor.blackColor;
    UIImageView *logoView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"gy_logo"]];
    [self.view addSubview:logoView];
    __weak CheckController *weakSelf = self;
    __weak UIView *weakLogoView = logoView;
    [logoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(weakSelf.view);
        make.top.mas_equalTo(120);
        make.width.height.mas_equalTo(66);
    }];
    
    UILabel *descLabel = [[UILabel alloc] init];
    descLabel.text = @"本机号码";
    descLabel.font = [UIFont systemFontOfSize:19];
    descLabel.textColor = [UIColor colorWithRed:49/255.0 green:169/255.0 blue:255/255.0 alpha:1];
    [self.view addSubview:descLabel];
    __weak UIView *weakDescLabel = descLabel;
    
    [descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(40);
        make.top.equalTo(weakLogoView.mas_bottom).offset(60);
        make.width.mas_equalTo(80);
        make.height.mas_equalTo(30);
    }];
    UITextField *textFiled = [[UITextField alloc] init];
    textFiled.attributedPlaceholder = [[NSAttributedString alloc] initWithString:@"请输入手机号码"
                                                                      attributes:@{NSForegroundColorAttributeName : [UIColor colorWithRed:167/255.0 green:218/255.0 blue:255/255.0 alpha:1],
                                                                                   NSFontAttributeName : [UIFont systemFontOfSize:13]
                                                                      }];
    textFiled.textColor = UIColor.blackColor;
    textFiled.keyboardType = UIKeyboardTypePhonePad;
    [self.view addSubview:textFiled];
    [textFiled mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(descLabel.mas_right).offset(6);
        make.top.bottom.equalTo(descLabel);
        make.right.mas_equalTo(-40);
    }];
    self.textField = textFiled;
    UIView *lineView = [[UIView alloc] init];
    lineView.backgroundColor = [UIColor colorWithRed:49/255.0 green:169/255.0 blue:255/255.0 alpha:1];
    [self.view addSubview:lineView];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(40);
        make.right.mas_equalTo(-40);
        make.height.mas_equalTo(1);
        make.top.equalTo(weakDescLabel.mas_bottom).offset(5);
    }];
    
    UIButton *verifyButton = [UIButton buttonWithType:UIButtonTypeCustom];
    CAGradientLayer *gradient = [CAGradientLayer layer];
    gradient.frame = CGRectMake(0, 0, 230, 45);
    gradient.colors = @[(id)[UIColor colorWithRed:49/255.0 green:169/255.0 blue:255/255.0 alpha:1].CGColor,(id)[UIColor colorWithRed:6/255.0 green:112/255.0 blue:222/255.0 alpha:1].CGColor];
    gradient.startPoint = CGPointMake(0, 0);
    gradient.endPoint = CGPointMake(1, 0);
    [verifyButton.layer addSublayer:gradient];
    [verifyButton setTitle:@"认证" forState:UIControlStateNormal];
    [verifyButton setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
    verifyButton.titleLabel.font = [UIFont boldSystemFontOfSize:18];
    verifyButton.layer.cornerRadius = 22.5;
    verifyButton.clipsToBounds = YES;
    [verifyButton addTarget:self action:@selector(verifyAction) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:verifyButton];
    __weak UIView *weakLineView = lineView;
    [verifyButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakLineView.mas_bottom).offset(75);
        make.size.mas_equalTo(CGSizeMake(230, 45));
        make.centerX.equalTo(weakSelf.view);
    }];
    UILabel *textLabel = [[UILabel alloc] init];
    textLabel.text = @"验证本机号码需将号码的数据网络打开，同时支持WiFi";
    textLabel.textAlignment = NSTextAlignmentCenter;
    textLabel.font = [UIFont systemFontOfSize:13];
    textLabel.textColor = UIColor.lightGrayColor;
    [self.view addSubview:textLabel];
    [textLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(weakSelf.view);
        make.bottom.mas_equalTo(-34);
    }];
}

- (void)dealloc {
    NSLog(@"dealloc %@", self);
}

@end
