//
//  GyHomeViewController.m
//  GyDemo
//
//  Created by ak on 2021/2/23.
//  Copyright © 2021 getui. All rights reserved.
//

#import "HomeViewController.h"
#import "LoginListController.h"
#import "CheckController.h"

@interface HomeViewController ()
@property (nonatomic, weak) UIButton *loginBtn;
@property (nonatomic, weak) UIButton *verifyBtn;
@property (nonatomic, weak) CAGradientLayer *gradient;
@end

@implementation HomeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupView];
}

- (void)loginAction {
    [self untaped:self.verifyBtn];
    [self taped:self.loginBtn];
    [self.navigationController pushViewController:[LoginListController new] animated:YES];
}

- (void)verifyAction {
    [self untaped:self.loginBtn];
    [self taped:self.verifyBtn];
    [self.navigationController pushViewController:[CheckController new] animated:YES];
}

- (void)setupView {
    self.view.backgroundColor = UIColor.whiteColor;
    //设置导航栏背景图片为一个空的image，这样就透明了
    [self.navigationController.navigationBar setBackgroundImage:[[UIImage alloc] init] forBarMetrics:UIBarMetricsDefault];
    //去掉透明后导航栏下边的黑边
    [self.navigationController.navigationBar setShadowImage:[[UIImage alloc] init]];
    
    CGFloat scale = kScreenScale;
    [self.navigationController setNavigationBarHidden:YES animated:NO];
    UIImageView *imageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"home_Bg"]];
    imageView.contentMode = UIViewContentModeScaleAspectFill;
    imageView.clipsToBounds = YES;
    imageView.frame = CGRectMake(0, 0, kScreenWidth, kScreenHeight - 240*scale);
    [self.view addSubview:imageView];
    
    UIView *actionContentView = [[UIView alloc] init];
    actionContentView.frame = CGRectMake(15, kScreenHeight - 270*scale, kScreenWidth - 30, 270*scale);
    actionContentView.backgroundColor = UIColor.whiteColor;
    [self.view addSubview:actionContentView];
    
    UIBezierPath *bezierPath = [UIBezierPath bezierPathWithRoundedRect:actionContentView.bounds byRoundingCorners:UIRectCornerTopLeft | UIRectCornerTopRight cornerRadii:CGSizeMake(12, 12)];
    CAShapeLayer *maskLayer = [[CAShapeLayer alloc] init];
    maskLayer.frame = actionContentView.bounds;
    maskLayer.path = bezierPath.CGPath;
    actionContentView.layer.mask = maskLayer;
    
    UIImageView *logoView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"gy_logo_dark"]];
    logoView.frame = CGRectMake(kScreenWidth / 2 - 58*scale, 66*scale, 52*scale, 52*scale);
    [imageView addSubview:logoView];
    
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.text = @"个验";
    titleLabel.textColor = UIColor.whiteColor;
    titleLabel.font = [UIFont boldSystemFontOfSize:32];
    titleLabel.frame = CGRectMake(CGRectGetMaxX(logoView.frame) + 6*scale, 66*scale, 120, 52*scale);
    [imageView addSubview:titleLabel];
    
    UILabel *subtitleLabel = [[UILabel alloc] init];
    subtitleLabel.text = @"您的新一代互联网综合验证解决方案";
    subtitleLabel.textColor = UIColor.whiteColor;
    subtitleLabel.font = [UIFont boldSystemFontOfSize:16];
    subtitleLabel.textAlignment = NSTextAlignmentCenter;
    subtitleLabel.frame = CGRectMake(0, CGRectGetMaxY(logoView.frame) + 15, kScreenWidth, 30);
    [imageView addSubview:subtitleLabel];
    
    UIButton *loginButton = [UIButton buttonWithType:UIButtonTypeCustom];
    loginButton.frame = CGRectMake(45, 60*scale, kScreenWidth - 120, 50*scale);
    [loginButton setTitle:@"一键登录" forState:UIControlStateNormal];
    loginButton.titleLabel.font = [UIFont boldSystemFontOfSize:18];
    [loginButton addTarget:self action:@selector(loginAction) forControlEvents:UIControlEventTouchUpInside];
    [actionContentView addSubview:loginButton];
   
    UIButton *verifyButton = [UIButton buttonWithType:UIButtonTypeCustom];
    verifyButton.frame = CGRectMake(45, CGRectGetMaxY(loginButton.frame)+25*scale, kScreenWidth - 120, 50*scale);
    [verifyButton setTitle:@"本机号码校验" forState:UIControlStateNormal];
    verifyButton.titleLabel.font = [UIFont boldSystemFontOfSize:18];
    [actionContentView addSubview:verifyButton];
    [verifyButton addTarget:self action:@selector(verifyAction) forControlEvents:UIControlEventTouchUpInside];

    UILabel *versionLabel = [[UILabel alloc] init];
    versionLabel.text = [NSString stringWithFormat:@"版本号：%@",[GeYanSdk getVersion]];
    versionLabel.textColor = UIColor.grayColor;
    versionLabel.font = [UIFont boldSystemFontOfSize:11];
    versionLabel.textAlignment = NSTextAlignmentCenter;
    versionLabel.frame = CGRectMake(0, CGRectGetMaxY(verifyButton.frame) + 40*scale, kScreenWidth - 30, 30);
    [actionContentView addSubview:versionLabel];
    [self untaped:loginButton];
    [self untaped:verifyButton];
    self.loginBtn = loginButton;
    self.verifyBtn = verifyButton;
}

- (void)untaped:(UIButton*)btn {
    if (self.gradient) {
        [self.gradient removeFromSuperlayer];
    }
    btn.backgroundColor = UIColor.whiteColor;
    [btn setTitleColor:[UIColor colorWithRed:6/255.0 green:112/255.0 blue:222/255.0 alpha:1] forState:UIControlStateNormal];
    
    btn.layer.cornerRadius = 25*kScreenScale;
    btn.layer.borderWidth = 1;
    btn.layer.borderColor = [UIColor colorWithRed:6/255.0 green:112/255.0 blue:222/255.0 alpha:1].CGColor;
    btn.clipsToBounds = YES;
}

- (void)taped:(UIButton*)btn {
    btn.backgroundColor = UIColor.whiteColor;
    [btn setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
    btn.layer.cornerRadius = 25*kScreenScale;
    btn.layer.borderWidth = 0;
    btn.clipsToBounds = YES;
    self.gradient = [Utils addGradient:btn];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:YES animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.navigationController setNavigationBarHidden:NO animated:animated];
}

@end
