//
//  GyLoginCustomView.m
//  GyDemo
//
//  Created by ak on 2021/3/2.
//  Copyright © 2021 getui. All rights reserved.
//

#import "LoginCustomView.h"

@implementation LoginCustomView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        UILabel *titleLabel = [[UILabel alloc] init];
        titleLabel.text = @"其他登录方式";
        titleLabel.textColor = UIColor.lightGrayColor;
        titleLabel.font = [UIFont systemFontOfSize:14];
        [self addSubview:titleLabel];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.centerX.equalTo(self);
        }];
        CGFloat space = (kScreenWidth - (3*40))/4.0;
        for (int i = 0; i < 3; i++) {
            UIImageView *imageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:[NSString stringWithFormat:@"custom_%d",i]]];
            [self addSubview:imageView];
            [imageView mas_makeConstraints:^(MASConstraintMaker *make) {
                make.width.height.mas_equalTo(40);
                make.bottom.equalTo(self);
                make.left.mas_equalTo((i+1)*space + 40*i);
            }];
        }
    }
    return self;
}

@end
