//
//  LoginListCell.m
//  GyDemo
//
//  Created by ak on 2021/2/23.
//  Copyright © 2021 getui. All rights reserved.
//

#import "LoginListCell.h"

@interface LoginListCell()
@property(nonatomic, strong) UIImageView *iconView;
@property(nonatomic, strong) UILabel *titleLabel;
@property(nonatomic, strong) UILabel *descLabel;
@end

@implementation LoginListCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.backgroundColor = UIColor.clearColor;
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        UIView *bgView = [[UIView alloc] init];
        bgView.layer.cornerRadius = 5;
        bgView.clipsToBounds = YES;
        bgView.backgroundColor = UIColor.whiteColor;
        [self.contentView addSubview:bgView];
        [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(15);
            make.right.mas_equalTo(-15);
            make.top.mas_equalTo(20*kScreenScale);
            make.bottom.mas_equalTo(0);
        }];
        self.iconView.layer.cornerRadius = 85*kScreenScale/2;
        self.iconView.clipsToBounds = YES;
        [bgView addSubview:self.iconView];
        [self.iconView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(25);
            make.centerY.equalTo(bgView.mas_centerY);
            make.width.height.mas_equalTo(85*kScreenScale);
        }];
        [bgView addSubview:self.titleLabel];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.iconView.mas_right).offset(25);
            make.bottom.mas_equalTo(bgView.mas_centerY);
            make.height.mas_equalTo(25);
        }];
        [bgView addSubview:self.descLabel];
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.iconView.mas_right).offset(25);
            make.top.mas_equalTo(bgView.mas_centerY);
            make.height.mas_equalTo(25);
        }];
        UIImageView *toView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"toback"]];
        //toView.frame = CGRectMake(bgView.frame.size.width - 25 - 8, bgHeight/2-8, 8, 16);
        [bgView addSubview:toView];
        [toView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.equalTo(bgView.mas_centerY);
            make.width.mas_equalTo(8);
            make.height.mas_equalTo(16);
            make.right.mas_equalTo(-25);
        }];
    }
    return self;
}

- (void)setItem:(NSArray *)item {
    _item = item;
    self.iconView.image = [UIImage imageNamed:item[0]];
    self.titleLabel.text = item[1];
    self.descLabel.text = item[2];
}

- (UIImageView *)iconView {
    if (!_iconView) {
        _iconView = [[UIImageView alloc] init];
        
    }
    return _iconView;
}

- (UILabel *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.font = [UIFont systemFontOfSize:18];
        _titleLabel.textColor = UIColor.blackColor;
    }
    return _titleLabel;
}

- (UILabel *)descLabel {
    if (!_descLabel) {
        _descLabel = [[UILabel alloc] init];
        _descLabel.font = [UIFont systemFontOfSize:15];
        _descLabel.textColor = [UIColor colorWithRed:118/255.0 green:118/255.0 blue:118/255.0 alpha:1];
    }
    return _descLabel;
}
@end
