//
//  NTZNavigationController.m
//  NewlyTech
//
//  Created by KJdiaoge on 16/3/30.
//  Copyright © 2016年 moyan. All rights reserved.
//

#import "NavigationController.h"
@interface NavigationController ()<UIGestureRecognizerDelegate>
@end

@implementation NavigationController

/**
 *  当导航控制器的view创建完毕就调用
 */
- (void)viewDidLoad {
    [super viewDidLoad];
    // 设置导航背景、字体色调
    [UINavigationBar appearance].tintColor = UIColor.whiteColor;
    NSMutableDictionary *md = [NSMutableDictionary dictionary];
    md[NSForegroundColorAttributeName] = [UIColor whiteColor];
    [[UINavigationBar appearance] setTitleTextAttributes:md];
    // 清空弹出手势的代理，就可以恢复弹出手势
    self.interactivePopGestureRecognizer.delegate = nil;
}

- (BOOL)shouldAutorotate {
    return self.topViewController.shouldAutorotate;
}

- (void)pushViewController:(UIViewController *)viewController animated:(BOOL)animated {
    NSLog(@"NavigationController pushViewController %@", viewController);
    [super pushViewController:viewController animated:animated];
}

- (UIViewController *)popViewControllerAnimated:(BOOL)animated {
    UIViewController *vc = [super popViewControllerAnimated:animated];
    NSLog(@"NavigationController popViewControllerAnimated %@", vc);
    return vc;
}

//- (BOOL)gestureRecognizerShouldBegin:(UIGestureRecognizer *)gestureRecognizer {
//    if (gestureRecognizer == self.interactivePopGestureRecognizer) {
//        // 屏蔽调用rootViewController的滑动返回手势，避免右滑返回手势引起死机问题
//        if (self.viewControllers.count < 2 || self.visibleViewController == [self.viewControllers objectAtIndex:0]) {
//            return NO;
//        }
//    }
//
//    return YES;
//}

//- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
//    return self.topViewController.supportedInterfaceOrientations;
//}
//
//- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation {
//    return self.topViewController.preferredInterfaceOrientationForPresentation;
//}
//// 状态栏设置
//- (UIViewController *)childViewControllerForStatusBarStyle {
//    return self.topViewController;
//}
//
///**
// *  当该类第一次用到的时候就调用
// */
//+ (void)initialize {
//    // 设置UINavigationBarTheme的主
//    [self setupNavigationBarTheme];
//
//    // 设置UIBarButtonItem的主题
//    [self setupBarButtonItemTheme];
//}
///**
// *  设置UINavigationBarTheme的主题
// */
//+ (void)setupNavigationBarTheme {
//    UINavigationBar *navBar = [UINavigationBar appearance];
//    // 设置导航栏背景
//    navBar.barTintColor = [UIColor colorWithRed:28.0/255.0 green:37.0/255.0 blue:41.0/255.0 alpha:1];
////    [navBar setBackgroundImage:[UIImage imageWithColor:RGBCOLOR(28, 37, 41)] forBarMetrics:UIBarMetricsDefault];
////    if (!iOS7) {
////        [navBar setBackgroundImage:[UIImage imageWithColor:RGBCOLOR(28, 37, 41)] forBarMetrics:UIBarMetricsDefault];
////    } else {
////        [navBar setBackgroundImage:[UIImage imageWithColor:RGBCOLOR(28, 37, 41)] forBarMetrics:UIBarMetricsDefault];
////    }
//
//    [navBar setTintColor:[UIColor whiteColor]];
//    // 设置文字属性
//    NSMutableDictionary *md = [NSMutableDictionary dictionary];
//    md[NSForegroundColorAttributeName] = [UIColor whiteColor];
//    md[NSFontAttributeName] = [UIFont fontWithName:@"PingFangSC-Medium" size:18];
//    [navBar setTitleTextAttributes:md];
//}
//
///**
// *  设置UIBarButtonItem的主题
// */
//+ (void)setupBarButtonItemTheme {
//    // 通过appearance对象能修改整个项目中所有UIBarButtonItem的样式
//    UIBarButtonItem *barItem = [UIBarButtonItem appearance];
//
//    /**设置文字属性**/
//    // 设置普通状态的文字属性
//    NSMutableDictionary *textAttrs = [NSMutableDictionary dictionary];
//    textAttrs[NSForegroundColorAttributeName] = [UIColor whiteColor];
//    textAttrs[NSFontAttributeName] = [UIFont systemFontOfSize:17];
//    [barItem setTitleTextAttributes:textAttrs forState:UIControlStateNormal];
//
//    // 设置高亮状态的文字属性
//    NSMutableDictionary *highTextAttrs = [NSMutableDictionary dictionaryWithDictionary:textAttrs];
//    highTextAttrs[NSForegroundColorAttributeName] = [UIColor lightGrayColor];
//    [barItem setTitleTextAttributes:highTextAttrs forState:UIControlStateHighlighted];
//
//    // 设置不可用状态(disable)的文字属性
//    NSMutableDictionary *disableTextAttrs = [NSMutableDictionary dictionaryWithDictionary:textAttrs];
//    disableTextAttrs[NSForegroundColorAttributeName] = [UIColor lightGrayColor];
//    [barItem setTitleTextAttributes:disableTextAttrs forState:UIControlStateDisabled];
//
//    //[barItem setTitleTextAttributes:@{ NSForegroundColorAttributeName : [UIColor clearColor] } forState:UIControlStateNormal];
//    /**设置背景**/
//    // 技巧: 为了让某个按钮的背景消失, 可以设置一张完全透明的背景图片
//    [barItem setBackgroundImage:[UIImage imageNamed:@"navigationbar_button_background"]
//                       forState:UIControlStateNormal
//                     barMetrics:UIBarMetricsDefault];
//}
//
//
//
//- (void)pushViewController:(UIViewController *)viewController animated:(BOOL)animated {
//    //拿到目标控制器(即将要入栈的控制器), 设置它的自动隐藏tabbar
//    viewController.hidesBottomBarWhenPushed = YES;
//    [super pushViewController:viewController animated:animated];
//}
@end
