//
//  GySuccessController.m
//  GyDemo
//
//  Created by ak on 2021/3/2.
//  Copyright © 2021 getui. All rights reserved.
//

#import "SuccessController.h"

@interface SuccessController ()
@property(nonatomic, strong) UILabel *textLabel;
@end

@implementation SuccessController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = UIColor.whiteColor;
    [self setupView];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.navigationController setNavigationBarHidden:YES animated:animated];
}

- (void)backAction {
    [self.navigationController popToRootViewControllerAnimated:YES];
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)setPn:(NSString *)pn {
    _pn = pn;
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc]
                                                   initWithString:self.tipTitle
                                                   attributes:@{
                                                       NSForegroundColorAttributeName : [UIColor darkGrayColor],
                                                       NSFontAttributeName: [UIFont boldSystemFontOfSize:30],
                                                   }];
    NSAttributedString *attr = [[NSAttributedString alloc] initWithString:[NSString stringWithFormat:@"\n手机号码为：%@",pn]
                                                               attributes:@{
                                                                   NSForegroundColorAttributeName : UIColor.lightGrayColor,
                                                                   NSFontAttributeName : [UIFont boldSystemFontOfSize:18]
                                                               }];
    [attributedString appendAttributedString:attr];
    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    paragraphStyle.alignment = NSTextAlignmentCenter;
    paragraphStyle.lineSpacing = 18; //行间距
    [attributedString addAttribute:NSParagraphStyleAttributeName value:paragraphStyle range:NSMakeRange(0, pn.length)];
    
    self.textLabel.attributedText = attributedString;
}

- (void)setupView {
    UIImageView *logoView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"success"]];
    [self.view addSubview:logoView];
    
    __weak SuccessController *weakSelf = self;
    [logoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(weakSelf.view);
        make.centerY.equalTo(weakSelf.view).offset(-200);
        make.width.height.mas_equalTo(65);
    }];
    [self.view addSubview:self.textLabel];
    
    __weak UIView *weakLogoView = logoView;
    [self.textLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakLogoView.mas_bottom);
        make.left.right.equalTo(weakSelf.view);
        make.height.mas_equalTo(140);
    }];
    UIButton *backButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [Utils addGradient:backButton frame:CGRectMake(0, 0, 230, 45)];
    [backButton setTitle:@"回到首页" forState:UIControlStateNormal];
    [backButton setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
    backButton.titleLabel.font = [UIFont boldSystemFontOfSize:18];
    
    backButton.layer.cornerRadius = 22.5;
    backButton.clipsToBounds = YES;
    [backButton addTarget:self action:@selector(backAction) forControlEvents:UIControlEventTouchUpInside];

    [self.view addSubview:backButton];
    [backButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(weakSelf.textLabel.mas_bottom);
        make.size.mas_equalTo(CGSizeMake(230, 45));
        make.centerX.equalTo(weakSelf.view);
    }];
}

- (UILabel *)textLabel {
    if (!_textLabel) {
        _textLabel = [[UILabel alloc] init];
        _textLabel.textAlignment = NSTextAlignmentCenter;
        _textLabel.numberOfLines = 0;
    }
    return _textLabel;
}

- (void)dealloc {
    NSLog(@"dealloc %@", self);
}

@end
