//
//  AppDelegate.m
//  Demo
//
//  Created by ak on 2022-05-24
//  Copyright (c) 2011年 Gexin Interactive (Beijing) Network Technology Co.,LTD. All rights reserved.
//

#import "AppDelegate.h"
#import <AVFoundation/AVFoundation.h>
#import "TabBarController.h"
#import "GtSdkDemo-Swift.h"
#import <AppTrackingTransparency/AppTrackingTransparency.h>
#import <AdSupport/ASIdentifierManager.h>


@interface AppDelegate()<GTCountSDKDelegate>
@end


@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    self.window = [[UIWindow alloc] initWithFrame:[UIScreen mainScreen].bounds];
    self.tabbarController = [[TabBarController alloc] init];
    self.eventTrackVC = self.tabbarController.eventTrackVC;
    self.window.rootViewController = self.tabbarController;
    [self.window makeKeyAndVisible];
    
    if (@available(iOS 14, *)) {
        ATTrackingManagerAuthorizationStatus status = ATTrackingManager.trackingAuthorizationStatus;
        NSLog(@"current status = %@", @(status));
        
        [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
            NSString *idfa = [ASIdentifierManager sharedManager].advertisingIdentifier;
            NSLog(@"status = %@ idfa=%@", @(status), idfa);
        }];
    }
    
    NSLog(@"%@",NSTemporaryDirectory());
    [GTCountSDK setDebugEnable:YES];
    [GTCountSDK setApplicationGroupIdentifier:@"group.ent.com.getui.demo"];
    [GTCountSDK sharedInstance].profileUploadInterval = 5000;
    [GTCountSDK sharedInstance].profileForceUploadSize = 5;
    [GTCountSDK sharedInstance].eventUploadInterval = 10000;
    [GTCountSDK sharedInstance].eventForceUploadSize = 30;
    [GTCountSDK startSDKWithAppId:kGtAppId withChannelId:@"" delegate:self];
    NSLog(@"gtcid:%@", [GTCountSDK gtcid]);
    
    //刷新小组件
    [WidgetTool reloadAllWidgets];
    return YES;
}

- (void)GTCountSDKDidReceiveGtcid:(NSString *)gtcid error:(NSError *)error {
    NSLog(@"GTCountSDKDidReceiveGtcid gtcid:%@ error:%@", gtcid, error);
}
@end
