//
//  EventTrackViewController.m
//  GTCountDemo
//
//  Created by ak on 2022-05-24
//  Copyright © 2017年 GeTui. All rights reserved.
//

#import "EventTrackViewController.h"

@interface EventTrackViewController ()
@property (nonatomic, weak) IBOutlet UITextField *eEventIdTF;
@property (nonatomic, weak) IBOutlet UITextField *eKeyTF;
@property (nonatomic, weak) IBOutlet UITextField *eValueTF;
@property (nonatomic, weak) IBOutlet UITextField *cEventIdTF;
@property (nonatomic, weak) IBOutlet UITextField *cKeyTF;
@property (nonatomic, weak) IBOutlet UITextField *cValueTF;
@property (nonatomic, weak) IBOutlet UITextField *pKeyTF;
@property (nonatomic, weak) IBOutlet UITextField *pValueTF;

@property (nonatomic, strong) NSMutableDictionary *eventPropDic;
@end

@implementation EventTrackViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"事件统计";
    _eventPropDic = [[NSMutableDictionary alloc] init];
    [self setupTextFields:@[self.eEventIdTF, self.eKeyTF, self.eValueTF, self.cEventIdTF, self.cValueTF , self.cKeyTF, self.pKeyTF, self.pValueTF]];
}

- (IBAction)eventBeginWithArg:(id)sender {
    if (_eEventIdTF.text.length == 0) {
        [self alertWithMsg:@"请输入事件 Id"];
        return;
    }
    [GTCountSDK trackCustomKeyValueEventBegin:_eEventIdTF.text];
    NSLog(@"eventBeginWithArg,eventId : %@",_eEventIdTF.text);
    [self resignKeyboard];
}

- (IBAction)eventEndWithArg:(id)sender {
    if (_eEventIdTF.text.length == 0) {
        [self alertWithMsg:@"请输入事件 Id"];
        return;
    }
    if (_eKeyTF.text.length > 0) {
        [self.eventPropDic removeAllObjects];
        [self.eventPropDic setObject:_eValueTF.text forKey:_eKeyTF.text];
        [GTCountSDK trackCustomKeyValueEventEnd:_eEventIdTF.text withArgs:self.eventPropDic withExt:@"ext-58"];
    }else{
        [GTCountSDK trackCustomKeyValueEventEnd:_eEventIdTF.text withArgs:nil withExt:@"ext-60"];
    }
    NSLog(@"eventEndWithArg,eventId : %@, property : %@",_eEventIdTF.text,self.eventPropDic);
    [self resignKeyboard];
}

- (IBAction)clickCount:(id)sender {
    if (_cEventIdTF.text.length == 0) {
        [self alertWithMsg:@"请输入事件 Id"];
        return;
    }
    if (_cKeyTF.text.length > 0) {
        [GTCountSDK trackCountEvent:_cEventIdTF.text withArgs:@{_cKeyTF.text:_cValueTF.text} withExt:@"ext-74"];
    }else{
        [GTCountSDK trackCountEvent:_cEventIdTF.text withArgs:nil withExt:@"ext-76"];
    }
    NSLog(@"clickCount,eventId : %@, property : %@",_cEventIdTF.text,@{_cKeyTF.text:_cValueTF.text});
    [self resignKeyboard];
}

- (IBAction)clickProfileSet:(id)sender {
    if (_pKeyTF.text.length == 0) {
        [self alertWithMsg:@"请输入Key Id"];
        return;
    }
    [GTCountSDK setProfile:@{_pKeyTF.text:_pValueTF.text} withExt:@"ext-94"];
    NSLog(@"clickProfileSet, property : %@",@{_pKeyTF.text:_pValueTF.text});
    [self resignKeyboard];
}

- (void)resignKeyboard {
    [self.view endEditing:YES];
}

- (void)setupTextFields:(NSArray *)textFieldList {
    [textFieldList enumerateObjectsUsingBlock:^(UITextField *tf, NSUInteger idx, BOOL * _Nonnull stop) {
//        tf.attributedPlaceholder = [[NSAttributedString alloc] initWithString:tf.placeholder attributes:@{NSForegroundColorAttributeName:[UIColor lightGrayColor]}];
        UIToolbar *keyboardDoneButtonView = [[UIToolbar alloc] init];
        [keyboardDoneButtonView sizeToFit];
        UIBarButtonItem *doneButton = [[UIBarButtonItem alloc] initWithTitle:@"Done"
                                                                       style:UIBarButtonItemStylePlain target:self
                                                                      action:@selector(resignKeyboard)];
        UIBarButtonItem *flex = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace target:nil action:nil];
        [keyboardDoneButtonView setItems:[NSArray arrayWithObjects:flex, doneButton, nil]];
        tf.inputAccessoryView = keyboardDoneButtonView;
    }];
}

- (void)alertWithMsg:(NSString *)msg{
    UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"提醒" message:msg delegate:nil
                                             cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
    [alertView show];
}

@end
