package com.getui.gssdk_demo_as_official_maven;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;
import android.widget.Toast;

import com.getui.gs.sdk.GsManager;

import org.json.JSONObject;

/**
 * Created by zhanglf on 2020/1/31.
 */

public class GsActivity extends Activity implements OnClickListener {
    private EditText mEditText1;
    private EditText key1;
    private EditText value1;
    private EditText mEditText4;
    private EditText key2;
    private EditText value2;
    private EditText key3;
    private EditText value3;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_gs);
        initView();
    }

    private void initView() {
        findViewById(R.id.button_diy1).setOnClickListener(this);
        findViewById(R.id.button_diy2).setOnClickListener(this);
        findViewById(R.id.bt_count).setOnClickListener(this);
        findViewById(R.id.bt_profile).setOnClickListener(this);
        mEditText1 = findViewById(R.id.et_event1);
        key1 = findViewById(R.id.et_key1);
        value1 = findViewById(R.id.et_value1);
        mEditText4 = findViewById(R.id.et_event2);
        key2 = findViewById(R.id.et_key2);
        value2 = findViewById(R.id.et_value2);
        key3 = findViewById(R.id.et_key3);
        value3 = findViewById(R.id.et_value3);

    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.button_diy1:

                if (TextUtils.isEmpty(mEditText1.getText().toString())) {
                    Toast.makeText(this, "请设置自定义事件 Event ID", Toast.LENGTH_SHORT).show();
                    return;
                }
                try {
                    JSONObject mProperties2 = new JSONObject();
                    String key = key1.getText().toString();
                    String value = value1.getText().toString();
                    if (!TextUtils.isEmpty(key) && !TextUtils.isEmpty(value)) {
                        mProperties2.put(key, value);
                        GsManager.getInstance().onBeginEvent(mEditText1.getText().toString(), mProperties2);
                    } else {
                        GsManager.getInstance().onBeginEvent(mEditText1.getText().toString());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            case R.id.button_diy2:
                if (TextUtils.isEmpty(mEditText1.getText().toString())) {
                    Toast.makeText(this, "请设置自定义事件 Event ID", Toast.LENGTH_SHORT).show();
                    return;
                }
                try {
                    JSONObject mProperties2 = new JSONObject();
                    String key = key1.getText().toString();
                    String value = value1.getText().toString();
                    if (!TextUtils.isEmpty(key) && !TextUtils.isEmpty(value)) {
                        mProperties2.put(key, value);
                        GsManager.getInstance().onEndEvent(mEditText1.getText().toString(), mProperties2);
                    } else {
                        GsManager.getInstance().onEndEvent(mEditText1.getText().toString());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            case R.id.bt_count:
                if (TextUtils.isEmpty(mEditText4.getText().toString())) {
                    Toast.makeText(this, "请设置自定义事件 Event ID", Toast.LENGTH_SHORT).show();
                    return;
                }
                try {
                    JSONObject mProperties3 = new JSONObject();
                    String key = key2.getText().toString();
                    String value = value2.getText().toString();
                    if (!TextUtils.isEmpty(key) && !TextUtils.isEmpty(value)) {
                        mProperties3.put(key, value);
                        GsManager.getInstance().onEvent(mEditText4.getText().toString(), mProperties3);
                    } else {
                        GsManager.getInstance().onEvent(mEditText4.getText().toString());
                    }
                    
                } catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            case R.id.bt_profile:
                JSONObject mProperties4 = new JSONObject();
                try {
                    String key = key3.getText().toString();
                    String value = value3.getText().toString();
                    mProperties4.put(key, value);
                    if (!TextUtils.isEmpty(key) && !TextUtils.isEmpty(value)) {
                        GsManager.getInstance().setProfile(mProperties4);
                    }
                    
                } catch (Exception e) {
                    e.printStackTrace();
                }

                break;
            default:
                break;
        }
    }

}
